<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Form\Form;
use WooBooking\CMS\Utilities\Utility;
if(!class_exists("WpBookingPro_OrderModel")) {
    /**
     * Class WpBookingPro_OrderModel
     */
    class WpBookingPro_OrderModel extends WoobookingModelForm
    {
        /**
         * @var string
         */
        public $context = "order";
        /**
         * @var string
         */
        public $table_name = "order";

        /**
         * @return bool|Form
         */
        public function getFormLayoutOrderDetail()
        {
            Form::addFieldPath(WPBOOKINGPRO_PATH_ROOT . '/lib/Form/Field');
            Form::addFieldPath(WPBOOKINGPRO_PATH_ROOT . '/lib/WooBooking/form/fields');
            Form::addFormPath(WPBOOKINGPRO_PATH_COMPONENT . '/models/forms');
            try {
                $form = Form::getInstance("order_detail");
            } catch (\Exception $e) {
                wpbookingpro_render_content($e->getMessage());
                die;
                $this->setError($e->getMessage());
                return false;
            }
            return $form;
        }

        /**
         * @param int $id
         * @return mixed|object
         */
        public function getItem($id = 0)
        {
            $item = (object)parent::getItem($id); // TODO: Change the autogenerated stub
            $query = $this->db->getQuery(true);
            $query->clear()
                ->select('customer.*')
                ->from($this->getTableName('customer') . ' AS customer')
                ->where('customer.id=' . (int)$item->customer_id);
            $item->customer = $this->db->setQuery($query)->loadObjectList();
            $item->customer_full_name = Utility::getFullName($item->customer[0]->first_name,
                $item->customer[0]->last_name);
            $query->clear()
                ->select("order_detail.*")
                ->from($this->getTableName('order_detail') . ' AS order_detail')
                ->where('order_detail.order_id=' . (int)$id);
            $item->list_order_detail = $this->db->setQuery($query)->loadObjectList();
            $list_rate=[];
            foreach ($item->list_order_detail as $order_detail) {
                $query->clear()
                    ->select("order_detail_rate.*")
                    ->from($this->getTableName('order_detail_rate') . ' AS order_detail_rate')
                    ->leftJoin($this->getTableName('service') . ' AS service ON service.id=order_detail_rate.service_id')
                    ->select('service.name as service_name,service.price as service_price,service.image as service_image')
                    ->leftJoin($this->getTableName('location') . ' AS location  ON location.id=order_detail_rate.location_id')
                    ->select('location.address AS location_address')
                    ->leftJoin($this->getTableName('employee') . ' AS employee  ON employee.id=order_detail_rate.employee_id')
                    ->select('employee.first_name AS employee_first_name,employee.last_name AS employee_last_name,employee.cover AS employee_cover')
                    ->where('order_detail_id=' . (int)$order_detail->id);
                $list_rate = $this->db->setQuery($query)->loadObjectList();
                foreach ($list_rate as &$rate) {
                    $start_date = Factory::getDate($rate->start_date);
                    $end_date = Factory::getDate($rate->end_date);
                    $since_start = $start_date->diff($end_date);
                    $rate->duration = WoobookingText::_sprintf('TIME_DURATION', $since_start->h, $since_start->i);
                    /////////////////////
                    $dateStart = date_parse_from_format('Y-m-d H:i:s', $start_date);
                    $dateEnd = date_parse_from_format('Y-m-d H:i:s', $end_date);
                    $dateStartTs = mktime(0, 0, 0, $dateStart['month'], $dateStart['day'], $dateStart['year']);
                    $dateEndTs = mktime(0, 0, 0, $dateEnd['month'], $dateEnd['day'], $dateEnd['year']);
                    $timeStartTs = mktime($dateStart['hour'], $dateStart['minute'], $dateStart['second'],
                        $dateStart['month'], $dateStart['day'], $dateStart['year']);
                    $timeEndTs = mktime($dateEnd['hour'], $dateEnd['minute'], $dateEnd['second'], $dateEnd['month'],
                        $dateEnd['day'], $dateEnd['year']);
                    $startDate = date('d/m/Y', $dateStartTs);
                    $endDate = date('d/m/Y', $dateEndTs);
                    $startTime = date('H:i', $timeStartTs);
                    $endTime = date('H:i', $timeEndTs);
                    $rate->list_date_detail = ($dateStartTs == $dateEndTs) ? $startDate : $startDate . ' - ' . $endDate;
                    $rate->list_time_detail = $startTime . ' - ' . $endTime;
                    $rate->employee_fullname = Utility::getFullName($rate->employee_first_name,
                        $rate->employee_last_name);
                }
                $order_detail->rate = $list_rate;
            }
            $item->list_rate = $list_rate;
            return $item;
        }
    }
}
