<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_BookingModel")) {
    /**
     * Class WpBookingPro_BookingModel
     */
    class WpBookingPro_BookingModel extends WoobookingModelForm
    {
        /**
         * @var string
         */
        public $context = "booking";
        /**
         * @var string
         */
        public $table_name = "event";

        /**
         * @return array
         */
        public function getHeader()
        {
            return array();
        }

        /**
         * @param $data
         * @return bool
         * @throws Exception
         */
        public function add_to_cart($data)
        {
            $list_rate = $data['rates'];
            $modelServices = WoobookingModel::getInstance('services');
            $list_service = $modelServices->getListServiceByListRateId($list_rate);
            foreach ($list_service as $service) {
                WC()->cart->add_to_cart($service->open_source_link_id);
            }
            return true;
        }

        /**
         * @return void|\WooBooking\CMS\Database\DatabaseQuery
         */
        public function buildQuery()
        {
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->select('*')
                ->from($this->getTableName('event'));
            return $query;
        }

        /**
         * @param int $id
         * @return mixed
         */
        public function getItem($id = 0)
        {
            $input = Factory::getInput();
            $id = $input->getInt('open_source_link_id', 0);
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->select("*")
                ->from($this->getTableName('service'))
                ->where('open_source_link_id=' . (int)$id);
            return $db->setQuery($query)->loadObject();
        }

        /**
         * @param $data
         * @return array|bool
         * @throws Exception
         */
        public function book_now($data)
        {
            $app = Factory::getApplication();
            $employee_id = $data['employee_id'];
            $rate_id = $data['rate_id'] ? $data['rate_id'] : $data['rates'][0];
            $number_person = $data['number_person'];
            $first_name = $data['first_name'];
            $last_name = $data['last_name'];
            $email = $data['email'];
            $phone = $data['phone'];
            $payment_id = $data['payment_id'];
            $customerModel = WoobookingModel::getInstance('customer');
            $data_customer = [
                "first_name" => $first_name,
                "last_name" => $last_name,
                "mobile" => $phone,
                "email" => $email
            ];
            $customer = $customerModel->save($data_customer);

            $rateModel = WoobookingModel::getInstance('rate');
            $rate = $rateModel->getItem($rate_id);
            $eventModel = WoobookingModel::getInstance('event');
            $event = $eventModel->getItem($rate->object_id);
            $service_id = $data['service_id'] ? $data['service_id'] : $event->service_id;
            $serviceModel = WoobookingModel::getInstance('service');
            $service = $serviceModel->getItem($service_id);
            $paymentModel = WoobookingModel::getInstance('payment');
            $payment = $paymentModel->getItem($payment_id);
            $multiply_number = $service->multiply_number;
            $quantity = $number_person;
            if ($multiply_number == 1) {
                $total = (int)$number_person * $event->price;
            } else {
                $total = $event->price;
            }
            $orderModel = WoobookingModel::getInstance('order');
            $data_order = [
                "customer_id" => $customer->id,
                "payment_id" => $payment_id,
                "total" => $total,
                "type" => WpBookingPro_RateHelper::getEventName()
            ];
            $order = $orderModel->save($data_order);
            $orderDetailModel = WoobookingModel::getInstance('orderdetail');
            $data_order_detail = [
                "id" => 0,
                "order_id" => $order->id,
                "quantity" => 1,
                "total" => $total,
                "employee_id" => $employee_id,
                "service_id" => $event->service_id,
                "location_id" => $event->location_id,
            ];
            $oder_detail = $orderDetailModel->save($data_order_detail);
            $orderDetailRateModel = WoobookingModel::getInstance('orderdetailrate');
            $data_order_detail_rate = [
                "id" => 0,
                "order_detail_id" => $oder_detail->id,
                "start_date" => $rate->from,
                "end_date" => $rate->to,
                "employee_id" => $employee_id,
                "rate_id" => $rate_id,
                "service_id" => $event->service_id,
                "location_id" => $event->location_id,
                "total" => $total,
                "price" => $event->price,
                "subtotal" => $total,
                "quantity" => $quantity,
            ];
            $order_detail_rate = $orderDetailRateModel->save($data_order_detail_rate);
            return $order;
        }
        public function book_service($data)
        {
            $app = Factory::getApplication();
            $employee_id = $data['employee_id'];
            $event_id = isset($data['event_id'])?$data['event_id']:0;
            $number_person = $data['number_person'];
            $first_name = $data['first_name'];
            $last_name = $data['last_name'];
            $email = $data['email'];
            $phone = $data['phone'];
            $payment_id = $data['payment_id'];
            $created_date = Factory::getDate();

            $customerModel = WoobookingModel::getInstance('customer');
            $data_customer = [
                "first_name" => $first_name,
                "last_name" => $last_name,
                "mobile" => $phone,
                "email" => $email
            ];
            $customer = $customerModel->save($data_customer);
            $event=array();
            if($event_id > 0) {
                $eventModel = WoobookingModel::getInstance('event');
                $event = $eventModel->getItem($event_id);
            }

            $service_id = $data['service_id'];
            $serviceModel = WoobookingModel::getInstance('service');
            $service = $serviceModel->getItem($service_id);
            $paymentModel = WoobookingModel::getInstance('payment');
            $payment = $paymentModel->getItem($payment_id);
            $start_date = $data['calendar'];
            $newtimestamp = strtotime($start_date.'+'. ($service->duration * 60).' minutes');
            $end_date = date('Y-m-d H:i:s', $newtimestamp);
            $multiply_number = $service->multiply_number;
            $quantity = $number_person;
            if ($multiply_number == 1) {
                if($event) {
                    $total = (int)$number_person * $event->price;
                } else {
                    $total = (int)$number_person * $service->price;
                }

            } else {
                if($event) {
                    $total = $event->price;
                } else {
                    $total = $service->price;
                }

            }
            $orderModel = WoobookingModel::getInstance('order');
            $data_order = [
                "customer_id" => $customer->id,
                "payment_id" => $payment_id,
                "total" => $total,
                "type" => $event?WpBookingPro_RateHelper::getEventName():WpBookingPro_RateHelper::getServiceName(),
                "created_date"=>$created_date->toSql()
            ];
            $order = $orderModel->save($data_order);
            $orderDetailModel = WoobookingModel::getInstance('orderdetail');
            $data_order_detail = [
                "id" => 0,
                "order_id" => $order->id,
                "quantity" => $quantity,
                "total" => $total,
                "employee_id" => $employee_id,
                "service_id" => $service_id,
                "location_id" => $event?$event->location_id:$service->location_id,
                "price" => $event?$event->price:$service->price
            ];
            $oder_detail = $orderDetailModel->save($data_order_detail);
            $orderDetailRateModel = WoobookingModel::getInstance('orderdetailrate');
            $data_order_detail_rate = [
                "id" => 0,
                "order_detail_id" => $oder_detail->id,
                "start_date" => $start_date,
                "end_date" => $end_date,
                "employee_id" => $employee_id,
                "service_id" => $service_id,
                "location_id" => $event?$event->location_id:$service->location_id,
                "total" => $total,
                "price" => $event?$event->price:$service->price,
                "subtotal" => $total,
                "quantity" => $quantity,
            ];
            $order_detail_rate = $orderDetailRateModel->save($data_order_detail_rate);
            return $order;
        }
    }
}
