<?php

defined('_WPBOOKINGPRO_EXEC') or die;

extract($displayData);

if ($multiple) {
	WpBookingPro_HtmlFrontend::_('jquery.ui', array('core', 'sortable'));
	WpBookingPro_HtmlFrontend::_('script', 'system/subform-repeatable.js', array('version' => 'auto', 'relative' => true));
}
$sublayout = empty($groupByFieldset) ? 'section' : 'section-byfieldsets';
?>
<div class="row-fluid">
    <div class="subform-repeatable-wrapper subform-layout">
        <div class="subform-repeatable"
             data-bt-add="a.group-add-<?php esc_html_e($unique_subform_id); ?>"
             data-bt-remove="a.group-remove-<?php esc_html_e($unique_subform_id); ?>"
             data-bt-move="a.group-move-<?php esc_html_e($unique_subform_id); ?>"
             data-repeatable-element="div.subform-repeatable-group-<?php esc_html_e($unique_subform_id); ?>"
             data-minimum="<?php esc_html_e($min); ?>" data-maximum="<?php esc_html_e($max); ?>"
        >
			<?php if (!empty($buttons['add'])) : ?>
                <div class="btn-toolbar">
                    <div class="btn-group">
                        <a class="btn btn-mini button btn-success group-add group-add-<?php esc_html_e($unique_subform_id); ?>"
                           aria-label="<?php esc_attr_e('Jglobal field add','wpbookingpro'); ?>">
                            <span class="icon-plus" aria-hidden="true"></span>
                        </a>
                    </div>
                </div>
			<?php endif; ?>
			<?php
			foreach ($forms as $k => $form) :
				esc_html_e($this->sublayout(
					$sublayout,
					array(
						'form' => $form,
						'basegroup' => $fieldname,
						'group' => $fieldname . $k,
						'buttons' => $buttons,
						'unique_subform_id' => $unique_subform_id,
					)
				));
			endforeach;
			?>
			<?php if ($multiple) : ?>
                <template class="subform-repeatable-template-section" style="display: none;"><?php
					
					echo str_replace(
						array('<', '>'),
						array('SUBFORMLT', 'SUBFORMGT'),
						trim(
							$this->sublayout(
								$sublayout,
								array(
									'form' => $tmpl,
									'basegroup' => $fieldname,
									'group' => $fieldname . 'X',
									'buttons' => $buttons,
									'unique_subform_id' => $unique_subform_id,
								)
							)
						)
					);
					?></template>
			<?php endif; ?>
        </div>
    </div>
</div>
