<?php
defined('_WPBOOKINGPRO_EXEC') or die;use WooBooking\CMS\Utilities\Utility;extract($displayData);
WpBookingPro_HtmlFrontend::_('jquery.framework');
WpBookingPro_HtmlFrontend::_('jquery.select2');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$list_rate = (array)$value;
?>
    <div id="<?php esc_html_e($id_by_name) ?>"
         class="<?php esc_html_e($class); ?> field-rates-<?php esc_html_e($name_format) ?> field-rates">
        <ul class="wrapper-list-rate">
			<?php foreach ($list_rate as $rate) { ?>
                <li>
                    <div class="wrapper-rate" data-rate_id="<?php esc_html_e($rate->id); ?>">
                        <div class="selected" style="display: none"><i class="fas fa-check-circle"></i></div>
                        <div class="rate">
                            <span>
                                <?php echo(WpBookingPro_HtmlFrontend::_('date', $rate->from,
                                    'H:i')); ?>-<?php echo(WpBookingPro_HtmlFrontend::_('date', $rate->to,
                                    'H:i A')); ?>
                            </span>
                        </div>
                    </div>
                </li>
			<?php } ?>
        </ul>
        <input type="hidden" name="<?php esc_html_e($name); ?>" />
    </div>
<?php
$doc=Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/layouts/WooBooking/form/field/rates.less');
$doc->addScriptApplySelector('.field-rates-'.$name_format,'field_rates',array(
    "field_name"=>  $name
),'nb_apps/nb_woobooking/layouts/WooBooking/form/field/rates.jquery.js');
