<?php
use WooBooking\CMS\Utilities\Utility;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

WpBookingPro_HtmlFrontend::_('jquery.fontawesome');
WpBookingPro_HtmlFrontend::_('jquery.daterangepicker');
WpBookingPro_HtmlFrontend::_('jquery.select2');
WpBookingPro_HtmlFrontend::_('jquery.moment');

$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$doc = Factory::getDocument();
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$list_rate = (array)$value;
if (!method_exists('render_item')) {
	function render_item($name, $from, $to, $required)
	{
		ob_start();
		?>
        <div class="item">
            <div class="input-rate">
                <input type="text" class="form-control m-input rate" value="<?php echo($from && $to ? "$from;$to" : '') ?>"/>
            </div>
            <div class="controllers">
                <button type="button" class="btn btn-add btn-primary pull-left"><i class="flaticon-add"></i>
                </button>
                <button type="button" class="btn btn-close-item btn-primary pull-left"><i
                            class="flaticon-close"></i></button>
            </div>
            <input type="hidden" class="rates" name="<?php esc_html_e($name); ?>[]" value="<?php echo($from && $to ? "$from;$to" : '') ?>"  />
        </div>
		<?php
		echo ob_get_clean();
	}

	;
}
$item_rate = '';
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-input-rate">
        <div class="list-item">
            <?php if (!count($list_rate)) {
                ob_start();
                render_item($name, "", "", $required);
                $item_rate = ob_get_flush();
            } else { ?>
                <?php foreach ($list_rate as $key => $rate) {
                    $key == 0 ? ob_start() : null;
                    render_item($name, $rate->from, $rate->to, $required);
                    $item_rate = $key == 0 ? ob_get_flush() : $item_rate;
                } ?>
            <?php } ?>
        </div>
    </div>
<?php
$doc=Factory::getDocument();
$doc->addScriptApplySelector('.field-input-rate','field_rate',array(
    "item_rate"=>  $item_rate,
    "input_name"=>  $name,
    "values"=>  $value,
),'nb_apps/nb_woobooking/layouts/WooBooking/form/field/rate.jquery.js');
