<?php

defined('_WPBOOKINGPRO_EXEC') or die;

use WooBooking\CMS\Utilities\Utility;

extract($displayData);


WpBookingPro_HtmlFrontend::_('jquery.framework');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$input = Factory::getInput();
$service_id = $input->getInt('service_id',0);
$modelService = WoobookingModel::getInstance('service');
$list_event=$modelService->getEventByServiceId($service_id);
$service=$modelService->getItem($service_id);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?>  field-list-event-of-service">
        <?php foreach ($list_event as $item) {?>
            <div class="block-event-item" data-event_id="<?php esc_html_e($item->id);?>">
                <div class="row main-event-item">
                    <div class="col-sm-2 col-md-2">
                        <div class="service-image-box">
                            <div>
                                <img src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?>/<?php esc_html_e($service->image) ?>" alt="service-image">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8 col-md-8">
                        <div class="wrapper-event-content">
                            <div class="header-event-content">
                                <h3><?php esc_html_e($item->name); ?></h3>
                            </div>
                            <div class="footer">
                                <p>
                                    <span>
                                        <i class="icon-nb-user"></i>
                                        <span>
                                            <?php esc_attr_e('Capacity','wpbookingpro') ?>: <?php esc_html_e($item->min_allowed_person . '/' . $item->max_allowed_person); ?>
                                        </span>
                                    </span>
                                    <span>
                                        <i class="icon-nb-pin"></i>
                                        <span>
                                            <?php foreach ($item->list_location as $list_location) {
                                                esc_html_e($list_location->address);
                                            }
                                            ?>
                                        </span>
                                    </span>
                                </p>
                                <p>
                                    <span>
                                        <i class="icon-nb-clock"></i>
                                        <span>
                                            <?php if($service->duration * 10 % 2 != 0) {?>
                                                <?php esc_attr_e('Duration','wpbookingpro') ?>: <?php printf("%s hours 30 minutes", floor($service->duration)); ?>
                                            <?php } else {?>
                                                <?php esc_attr_e('Duration','wpbookingpro') ?>: <?php printf("%s hours", floor($service->duration)); ?>
                                            <?php } ?>
                                        </span>
                                    </span>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-2 col-md-2 label-price">
                        <div class="wrapper-label">
                            <span class="sticky label label-primary"><?php echo(WpBookingPro_FrontEndHelper::format_currency($item->price))  ?></span>
                        </div>
                    </div>
                </div>
                <div class="row row-button-action">
                    <div class="col-md-12">
                        <div class="wrapper-button-action">
                            <div class="btn-booknow">
                                <span><?php esc_attr_e('Book now','wpbookingpro')?></span>
                                <i class="icon-nb-down-arrow"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php }?>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('nb_apps/nb_woobooking/layouts/WooBooking/form/field/listeventofservice/listeventofservice.less');
$doc->addStyleSheet('nb_apps/nb_woobooking/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.field-list-event-of-service','field_listeventofservice',array(
),'nb_apps/nb_woobooking/layouts/WooBooking/form/field/listeventofservice/listeventofservice.jquery.js');