<?php

defined('_WPBOOKINGPRO_EXEC') or die;

use WooBooking\CMS\Utilities\Utility;

extract($displayData);


WpBookingPro_HtmlFrontend::_('jquery.framework');
WpBookingPro_HtmlFrontend::_('jquery.slick');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$input= Factory::getInput();
$service_id= $input->getInt('service_id',0);
$modelService = WoobookingModel::getInstance('service');
$service_item = $modelService->getItem($service_id);
$list_employee = $service_item->list_employee;
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-employeeimageslider">
        <div class="row">
            <div class="list-employee">
                <?php foreach ($list_employee as $item) { ?>
                    <div class="wrapper-employee" data-employee_id="<?php esc_html_e($item->id); ?>">
                        <div class="selected" style="display: none"><i class="fas fa-check-circle"></i></div>
                        <div class="img-box">
                            <div>
                                <img class="employee-image" src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?>/<?php esc_html_e($item->image); ?>" alt="employee-image" />
                            </div>
                        </div>
                        <p><?php esc_html_e($item->full_name); ?></p>
                        <input type="hidden" name="<?php esc_html_e($name); ?>" />
                    </div>
                <?php } ?>
            </div>
        </div>
        <span class="left"><i class="icon-nb-down-arrow"></i></span>
        <span class="right"><i class="icon-nb-down-arrow"></i></span>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('nb_apps/nb_woobooking/layouts/WooBooking/form/field/employeeimageslider/employeeimageslider.less');
$doc->addScriptApplySelector('.field-employeeimageslider','field_employeeimageslider',array(
    "field_name"=>  $name
),'nb_apps/nb_woobooking/layouts/WooBooking/form/field/employeeimageslider/employeeimageslider.jquery.js');