(function ($) {
    $.field_employeeimageslider = function (element, options) {
        var defaults = {
            field_name: 0
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;

        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let field_name = plugin.settings.field_name;
            $element.find('.wrapper-employee').click(function (e) {
                let $self = $(this);
                $element.find('.wrapper-employee .selected').hide();
                $element.find('.wrapper-employee p').removeClass('active');
                let employee_id = $self.data('employee_id');
                $self.find('.selected').show();
                $self.find('p').addClass('active');
                $element.find(`input[name="${field_name}"]`).val(employee_id);
            });
            $element.find('.list-employee').slick({
                infinite: true,
                slidesToShow: 3,
                slidesToScroll: 1,
                responsive: [
                    {
                        breakpoint: 1200,
                        settings: {
                            arrows: false,
                            slidesToShow: 2,
                            slidesToScroll: 2
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            arrows: false,
                            slidesToShow: 2,
                            slidesToScroll: 2
                        }
                    },
                    {
                        breakpoint: 767,
                        settings: {
                            arrows: false,
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 576,
                        settings: {
                            arrows: false,
                            dots:true,
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    }
                ]
            });
            $element.find('.left').click(function(){
                $element.find('.list-employee').slick('slickPrev');
            });

            $element.find('.right').click(function(){
                $element.find('.list-employee').slick('slickNext');
            });
        };
        plugin.getValue = function () {
            let field_name = plugin.settings.field_name;
            return $element.find(`input[name="${field_name}"]`).val();
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_employeeimageslider = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_employeeimageslider')) {
                var plugin = new $.field_employeeimageslider(this, options);
                $(this).data('field_employeeimageslider', plugin);
            }
        });
    }
})(jQuery);
