(function ($) {
    $.field_calendardatetime = function (element, options) {
        var defaults = {
            field_name: ""
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find(".form_datetime").datetimepicker({
                format: "yyyy-mm-dd hh:ii",
                autoclose: true,
                minuteStep: 10,
                pickerPosition: "bottom-left"
            }).on('changeDate', function (ev) {
                $(`input[name="${plugin.settings.field_name}"]`).val(moment(ev.date).format('YYYY-MM-DD HH:mm:ss'));
            });
            $element.find('.add-on:nth-child(2)').click(function (e) {
                $element.find(`input[name="${plugin.settings.field_name}"]`).val('')
            });
            $('.dropdown-menu').find('.glyphicon').addClass('icon-nb-down-arrow');
        };
        plugin.example_function = function () {
        };
        plugin.init();
    };

    $.fn.field_calendardatetime = function (options) {

        return this.each(function () {

            if (undefined === $(this).data('field_calendardatetime')) {
                var plugin = new $.field_calendardatetime(this, options);
                $(this).data('field_calendardatetime', plugin);
            }
        });
    }
})(jQuery);