<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_CartController")) {
    /**
     * Class WpBookingPro_CartController
     */
    class WpBookingPro_CartController extends woobooking_controller_frontend
    {
        /**
         * @return mixed
         * @throws Exception
         */
        public function ajax_search_cart()
        {
            $servicesModel = WoobookingModel::getInstance('carts');
            return $servicesModel->getList();
        }

        /**
         * @throws Exception
         */
        public function add_to_cart()
        {
            $input = Factory::getInput();
            $post = $input->getData();
            $modelCart = WoobookingModel::getInstance('cart');
            $cart_item = $modelCart->add_to_cart($post);
            if ($cart_item) {
                $this->redirectInWooBookingPage('cart-list');
            }
        }

        /**
         * @return bool
         * @throws Exception
         */
        public function ajax_delete()
        {
            $input = Factory::getInput();
            $modelCart = WoobookingModel::getInstance('cart');
            $id = $input->getInt('id');
            $modelCart->delete($id);
            return true;
        }

        /**
         * @return bool
         * @throws Exception
         */
        public function ajax_delete_more()
        {
            $input = Factory::getInput();
            $modelCart = WoobookingModel::getInstance('cart');
            $list_delete_cart_item = $input->get('list_delete_cart_item', array(), 'array');
            foreach ($list_delete_cart_item as $cart_item) {
                $modelCart->delete($cart_item);
            }
            return true;
        }
    }
}