"use strict";
(function ($) {
    $.view_list_cart = function (element, options) {
        let defaults = {
            list_cart: []
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let list_cart = plugin.settings.list_cart;
            $element.find('.btn-delete').click(function (e) {
                let id = $(this).closest('.list-cart').data('id');
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure delete product in cart ?',
                    container: '.block-confirm',
                    buttons: {
                        confirm: {
                            btnClass: 'btn-green',
                            action: function () {
                                $.ajax({
                                    type: "POST",
                                    dataType: "json",
                                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                                    data: {
                                        task: "cart.ajax_delete",
                                        id: id
                                    },
                                    success: function (response) {
                                        location.reload(true);
                                    }
                                });
                            }
                        },
                        cancel:{
                            btnClass: 'btn-blue',
                            action: function () {
                            }
                        }
                    }
                });
            });
            $element.find('input[type="checkbox"].delete-cart-item').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            })
            $element.find('.btn-delete-cart-item-more').click(function (e) {
                let list_delete_cart_item = [];
                $element.find('.delete-cart-item:checked').each(function (e) {
                    list_delete_cart_item.push($(this).val());
                })
                if (list_delete_cart_item.length === 0) {
                    $.alert({
                        title: 'Error',
                        content: 'Please choose employee before delete!',
                        container: '.block-confirm',
                        buttons: {
                            ok: {
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure delete this image in gallery ?',
                    container: '.block-confirm',
                    buttons: {
                        confirm:  {
                            btnClass: 'btn-green',
                            action: function () {
                                $.ajax({
                                    type: "POST",
                                    dataType: "json",
                                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                                    data: {
                                        task: "cart.ajax_delete_more",
                                        list_delete_cart_item: list_delete_cart_item
                                    },
                                    success: function (response) {
                                        location.reload(true);
                                    }
                                });
                            }
                        },
                        cancel: {
                            btnClass: 'btn-blue',
                            action: function () {
                            }
                        }
                    }
                });
            })
        };
        plugin.example_function = function () {
        };
        plugin.init();
    };
    $.fn.view_list_cart = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('view_list_cart')) {
                let plugin = new $.view_list_cart(this, options);
                $(this).data('view_list_cart', plugin);
            }
        });
    };
    var quantitiy = 0;
    $('.quantity-right-plus').click(function (e) {
        e.preventDefault();
        var quantity = parseInt($('#quantity').val());
        $('#quantity').val(quantity + 1);
    });
    $('.quantity-left-minus').click(function (e) {
        e.preventDefault();
        var quantity = parseInt($('#quantity').val());
        if (quantity > 0) {
            $('#quantity').val(quantity - 1);
        }
    });
})(jQuery);
