"use strict";
(function ($) {
    $.view_checkout_page = function (element, options) {
        let defaults = {
            list_cart: []
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let list_cart = plugin.settings.list_cart;
            $element.find('form[name="client-form"]').each(function (e) {
                $(this).validate({
                    ignore: ""
                });
            });
            $element.find('.btn-paynow-checkout').click(function (e) {
                let $form = $(this).closest('form');
                let location_id = $form.find('select[name="location_id"].list-location').val();
                $.each(list_cart, function (index, cart) {
                    $form.find('input[name="rate_id[]"]').val(cart.rate_id);
                    $form.find('input[name="service_id[]"]').val(cart.service_id);
                });
                if (!$form.valid()) {
                    return false;
                }
                if (location_id == '') {
                    $.alert({
                        title: 'Error',
                        content: 'Please select location !',
                    });
                    return false;
                }
                $form.submit();
            });
            $element.find('.btn-delete').click(function (e) {
                let id = $(this).closest('.list-cart').data('id');
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure delete product in cart ?',
                    container: '.block-confirm',
                    buttons: {
                        confirm: {
                            btnClass: 'btn-green',
                            action: function () {
                                $.ajax({
                                    type: "POST",
                                    dataType: "json",
                                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                                    data: {
                                        task: "cart.ajax_delete",
                                        id: id
                                    },
                                    success: function (response) {
                                        location.reload(true);
                                    }
                                });
                            }
                        },
                        cancel:{
                            btnClass: 'btn-blue',
                            action: function () {
                            }
                        }
                    }
                });
            });
            $element.find('input[type="checkbox"].delete-cart-item').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            })
            $element.find('.btn-delete-cart-item-more').click(function (e) {
                let list_delete_cart_item = [];
                $element.find('.delete-cart-item:checked').each(function (e) {
                    list_delete_cart_item.push($(this).val());
                });
                if (list_delete_cart_item.length === 0) {
                    $.alert({
                        title: 'Error',
                        content: 'Please choose employee before delete!',
                        container: '.block-confirm',
                        buttons: {
                            ok: {
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure delete this image in gallery ?',
                    container: '.block-confirm',
                    buttons: {
                        confirm:  {
                            btnClass: 'btn-green',
                            action: function () {
                                $.ajax({
                                    type: "POST",
                                    dataType: "json",
                                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                                    data: {
                                        task: "cart.ajax_delete_more",
                                        list_delete_cart_item: list_delete_cart_item
                                    },
                                    success: function (response) {
                                        location.reload(true);
                                    }
                                });
                            }
                        },
                        cancel: {
                            btnClass: 'btn-blue',
                            action: function () {
                            }
                        }
                    }
                });
            })
        };
        plugin.example_function = function () {
        };
        plugin.init();
    };
    $.fn.view_checkout_page = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('view_checkout_page')) {
                let plugin = new $.view_checkout_page(this, options);
                $(this).data('view_checkout_page', plugin);
            }
        });
    }
})(jQuery);
