<?php
use WooBooking\CMS\Utilities\Utility;
WpBookingPro_HtmlFrontend::_('jquery.ui');
WpBookingPro_HtmlFrontend::_('jquery.animated_modal');
WpBookingPro_HtmlFrontend::_('jquery.confirm');
WpBookingPro_HtmlFrontend::_('jquery.validate');

$doc = Factory::getDocument();
$doc->addLessStyleSheet('blocks/block_priceplanclass/assets/lesss/default.less');
$doc->addStyleSheet('nb_apps/nb_woobooking/assets/nb-font-icon/nb-font-icon.css');
$list_key=array_keys($list_pack);
?>
    <div  class="block-priceplanclass-default">
        <div class="block-confirm-2"></div>
        <div class="row">
            <?php foreach ($list_pack as $key => $package) { ?>
                <div class="col-sm-6 col-md-4">
                    <div class="wrapper-block-priceplanclass <?php echo ($key==$list_key[1])?'priceplanclass-hover':'' ?>" id="<?php echo ($key==$list_key[1])?'priceplanclass-hover':'priceplanclass-'.$package->id?>" data-package_id="<?php esc_html_e($package->id);?>">
                        <div class="block-priceplanclass">
                            <div class="block-priceplanclass-top">
                                <div class="border-top"></div>
                                <div class="content-priceplanclass-top">
                                    <div class="title-card">
                                        <h3><?php esc_html_e($package->name);?></h3>
                                    </div>
                                    <div class="price-priceplanclass">
                                        <span><?php echo WpBookingPro_FrontEndHelper::format_currency($package->price) ?></span>
                                        <span>/month</span>
                                    </div>
                                </div>
                            </div>
                            <div class="block-priceplanclass-bottom">
                                <div class="wrapper-item-priceplanclass">
                                    <?php foreach ($package->list_event as $event) {?>
                                        <div class="item-priceplanclass">
                                            <span><i class="icon-nb-calendar"></i></span>
                                            <span><?php esc_html_e($event->name);?></span>
                                        </div>
                                    <?php }?>
                                </div>
                                <div class="button-action-priceplanclass text-center">
                                    <button class="btn btn-info btn-action-priceplanclass"><?php esc_attr_e('Choose plan','wpbookingpro')?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
        <div class="modal  form-input-info" role="dialog">
            <div class="modal-dialog modal-lg form-input-info-dialog" role="document">
                <div class="modal-content form-input-info-content">
                    <form action="#" method="post" name="client-form">
                        <div class="modal-header form-input-info-header">
                            <h3 class="modal-title"><?php esc_attr_e('Booking info','wpbookingpro')?></h3>
                        </div>
                        <div class="modal-body form-input-info-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="wrapper-service">
                                        <div class="img-box">
                                            <div>
                                                <img class="service-cover" src="<?php echo Factory::getRootUrlPlugin().'assets/images/cover.jpg' ?>" alt="service-cover" />
                                            </div>
                                        </div>
                                        <h4 class="service-name">Vinyasa Yoga</h4>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="list-event-package">
                                        <ul class="nav nav-tabs tab-list-event"></ul>
                                        <div class="tab-content tab-list-event-content"></div>
                                        <button type="button" class="btn btn-danger btn-close-modal" data-dismiss="modal"><span><?php esc_attr_e('CLOSE')?></span></button>
                                        <button class="btn btn-primary btn-continue-booking"><?php esc_attr_e('Continue','wpbookingpro')?></button>
                                    </div>
                                </div>
                            </div>
                            <div class="form-customer-info">
                                <div class="row">
                                    <div class="col-md-12">
                                        <a href="#" class="back-to-step"><i class="fas fa-arrow-left"></i><span><?php esc_attr_e('Back','wpbookingpro')?></span></a>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="input-firstname">
                                            <?php
                                            $field = $form_booking->getField('first_name');
                                            echo($field->input);
                                            ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="input-lastname">
                                            <?php
                                            $field = $form_booking->getField('last_name');
                                            echo($field->input);
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="input-email">
                                            <?php
                                            $field = $form_booking->getField('email');
                                            echo($field->input);
                                            ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="input-phone">
                                            <?php
                                            $field = $form_booking->getField('phone');
                                            $field->setId('phone' . rand(700, 30000));
                                            echo($field->input);
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <?php
                                    $field = $form_booking->getField('payment_id');
                                    $disable_payment_online = (boolean)isset($item->disable_payment_online) ? $item->disable_payment_online : false;
                                    $field->setDisablePaymentOnline($disable_payment_online);
                                    ?>
                                    <div class="col-sm-6">
                                        <p><?php esc_attr_e('Select payment','wpbookingpro')?></p>
                                        <?php echo($field->input); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="form-info-payment">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="block-payment-item">
                                            <p><?php esc_attr_e('Payment info','wpbookingpro') ?></p>
                                            <div class="detail-payment-item">
                                                <span><?php esc_attr_e('Total number of persons','wpbookingpro') ?>:</span>
                                                <span class="total-person">1</span>
                                            </div>
                                            <div class="detail-payment-item">
                                                <span><?php esc_attr_e('Base price','wpbookingpro') ?>:</span>
                                                <span class="base-price"
                                                      data-price="<?php esc_html_e($item->price) ?>">
                                                        <?php
                                                        echo WpBookingPro_FrontEndHelper::format_currency($item->price)
                                                        ?>
                                                    </span>
                                            </div>
                                            <div class="detail-payment-item" style="display: none">
                                                <span><?php esc_attr_e('Discount','wpbookingpro') ?>:</span>
                                                <span>$0.00</span>
                                            </div>
                                            <div class="add-coupon" style="display: none">
                                                <span><?php esc_attr_e('Add coupon','wpbookingpro') ?>:</span>
                                                <div class="add-coupon-input">
                                                    <input type="text" class="coupon_code" />
                                                    <button type="button" class="btn btn-primary"><i
                                                            class="fas fa-check"></i></button>
                                                </div>
                                            </div>
                                            <div class="detail-payment-item total-cost">
                                                <span><?php esc_attr_e('Total cost','wpbookingpro') ?>:</span>
                                                <span class="total-cost-sum">$15.00</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer form-input-info-footer">
                            <button type="button" class="btn btn-primary btn-close-modal" data-dismiss="modal"><span><?php esc_attr_e('Close','wpbookingpro')?></span></button>
                            <button type="submit" class="btn btn-danger btn-buying-modal-now"><span><?php esc_attr_e('Buy now','wpbookingpro')?></span></button>
                        </div>
                        <input type="hidden" name="task" value="cart.add_to_cart" />
                        <input type="hidden" name="package_id" />
                    </form>
                </div>
            </div>
        </div>
    </div>

<?php

$doc->addScriptApplySelector('.block-priceplanclass-default','block_priceplanclass_default',array(
    "list_package"=>  $list_pack
),'blocks/block_priceplanclass/assets/js/jquery.block_priceplanclass_default.js');