<?php
use WooBooking\CMS\Application\NBAppHelper;
use WooBooking\CMS\Utilities\Utility;
$doc = Factory::getDocument();
$appConfig = Factory::getAppConfig();
$doc->addLessStyleSheet('blocks/block_location/assets/lesss/default.less');
?>
    <div class="block-location-default">
        <h2 class="block-location-title"><?php echo WoobookingText::_('FIND_THE_FITNESS_CENTER_CLOSEST_TO_YOU')?></h2>
        <p><?php esc_attr_e('Choose the one that best suits you to start training with our quickest way to lose weight, or find out more about','wpbookingpro')?> <br> <?php esc_attr_e('the upcoming centers near you','wpbookingpro')?></p>
            <div class="row">
                <?php foreach ($list_location as $location) { ?>
                    <div class="col-sm-6 col-md-4">
                        <div class="wrapper-banner-location">
                            <div class="img-location">
                                <div>
                                    <img src="<?php esc_html_e($location->banner);?>" alt="img-location" />
                                </div>
                            </div>
                            <div class="layer-blur"></div>
                            <div class="name-location">
                                <a href="<?php  echo Utility::getFrontendGoToLink("event.find_event",array("location_id"=>$location->id))?>">
                                    <?php esc_html_e($location->name);?>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>

<?php
$doc->addScriptApplySelector('.block-location-default','block_location_default',array(
),'blocks/block_location/assets/js/jquery.block_location_default.js');