"use strict";
(function ($) {
    $.block_listevent_default = function (element, options) {
        let defaults = {
            list_event:[]
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let list_event = plugin.settings.list_event;
            $element.find('.wrapper-button-action').click(function (e) {
                let $row=$(this).closest('.row-button-action');
                $(this).toggleClass('active');
                $row.find('.btn-booknow').toggleClass('hidden');
                $row.find('.btn-cancel').toggleClass('shown');
                $row.next().slideToggle();
                $row.next().next().slideToggle();
            });
            $element.find('.pagination-list-finance').twbsPagination({
                totalPages: 35,
                visiblePages: 7,
                onPageClick: function (event, page) {
                    $('#page-content').text('Page ' + page);
                }
            });
            $element.find('.img-box-event-item').fancybox({
                'transitionIn'	:	'elastic',
                'transitionOut'	:	'elastic',
                'speedIn'		:	600,
                'speedOut'		:	200,
                'overlayShow'	:	true,
            });
            $element.find('form[name="client-form"]').each(function (e) {
                $(this).validate({
                    ignore: ""
                });
            });
            $element.find('.btn-continue-book-now').click(function (e) {
                let $form=$(this).closest('form');
                let $field_employeeimage_employee_id=$form.find('.field-employeeimage-employee_id').data('field_employeeimage');
                if($field_employeeimage_employee_id.getValue()===""){
                    $.alert({
                        title:'',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your employee</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container:'.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                let $rate_id=$form.find('.field-rates-rate_id').data('field_rates');
                if($rate_id.getValue()===""){
                    $.alert({
                        title:'',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your time</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container:'.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                let $event_item=$(this).closest('.event-item');
                let event_id = $event_item.data('event_id');
                let event = plugin.getEvent(event_id);
                let list_employee = event.list_employee;
                let employee_id= $field_employeeimage_employee_id.getValue();
                let list_rate = event.list_rate;
                let rate_id= $rate_id.getValue();
                let employee = plugin.getEmployee(list_employee, employee_id);
                let rate = plugin.getRate(list_rate, rate_id);
                $event_item.addClass('booking-now');
                let number_person = $event_item.find('.increment-number').val();
                $event_item.find('.number-person').text(number_person);
                let base_price = $event_item.data('event_price');
                if (number_person == 1) {
                    $event_item.find('.base-price').text('$ ' + base_price);
                } else {
                    $event_item.find('.base-price').text('$ ' + base_price * number_person)
                }
                $event_item.find('.total-cost-sum').text('$ ' + number_person * base_price);
                $event_item.find('.trainer-info').text(employee.full_name);
                $event_item.find('.time-info').text(rate.start_time + ' - ' +rate.end_time);
            });
            $element.find('.btn-cancel').click(function (e) {
                let $event_item=$(this).closest('.event-item');
                $event_item.removeClass('booking-now');
            });
            $element.find('.btn-book-now').click(function (e) {
                let $form=$(this).closest('form');
                $form.find('input[name="task"]').val('booking.book_now');
                if(!$form.valid())
                {
                    return false;
                }
                $form.submit();
            });
            $element.find('.btn-add-to-cart').click(function (e) {
                let $form=$(this).closest('form');
                $form.find('input[name="task"]').val('cart.add_to_cart');
                if(!$form.valid())
                {
                    return false;
                }
                $form.submit();
            });
            $element.find('form').submit(function (e) {
                let $current_form=$(this);
                let field_pickdatetimedropdown_time=$element.find('.field-pickdatetimedropdown-time').data('field_pickdatetimedropdown');
                let datetime=field_pickdatetimedropdown_time.getValue();
                $current_form.find('input[name="datetime"]').val(datetime);
                let $field_yesno_outdoor=$element.find('.field-yesno-outdoor').data('field_yesno');
                let outdoor=$field_yesno_outdoor.getValue();
                $current_form.find('input[name="outdoor"]').val(outdoor);
                return true;
            });
        };
        plugin.getEvent = function (event_id) {
            event_id = parseInt(event_id);
            let data = plugin.settings.list_event;
            for (let i = 0; i < data.length; i++) {
                let event = data[i];
                if (parseInt(event.id) === event_id) {
                    return event;
                }
            }
            return false;
        };
        plugin.getEmployee = function (list_employee,employee_id) {
            employee_id = parseInt(employee_id);
            for (let i = 0; i < list_employee.length; i++) {
                let employee = list_employee[i];
                if (parseInt(employee.id) === employee_id) {
                    return employee;
                }
            }

            return false;
        };
        plugin.getRate = function (list_rate,rate_id) {
            rate_id = parseInt(rate_id);
            for (let i = 0; i < list_rate.length; i++) {
                let rate = list_rate[i];
                if (parseInt(rate.id) === rate_id) {
                    return rate;
                }
            }
            return false;
        };
        plugin.example_function = function () {
        };
        plugin.init();
    };

    $.fn.block_listevent_default = function (options) {

        return this.each(function () {

            if (undefined === $(this).data('block_listevent_default')) {
                let plugin = new $.block_listevent_default(this, options);
                $(this).data('block_listevent_default', plugin);
            }
        });
    }
})(jQuery);
