<?php
use WooBooking\CMS\Application\NBAppHelper;
use WooBooking\CMS\Utilities\Utility;
$appConfig=Factory::getAppConfig();
$root_url=Factory::getRootUrl();
$booking_style=$appConfig->get('booking_style');
$multi_product_in_cart=$appConfig->get('multi_product_in_cart',0);
if($item) {
    $doc = Factory::getDocument();
    WpBookingPro_HtmlFrontend::_('jquery.moment');
    WpBookingPro_HtmlFrontend::_('jquery.serialize_object');
    WpBookingPro_HtmlFrontend::_('jquery.confirm');
    WpBookingPro_HtmlFrontend::_('jquery.validate');
    WpBookingPro_HtmlFrontend::_('jquery.ui');
    $doc->addLessStyleSheet('blocks/block_bookingtraining/assets/lesss/default.less');
    ?>
    <div class="block-bookingtraining-default">
        <div class="block-confirm-1"></div>
        <form action="<?php echo Factory::getRootUrl() ?>wp-booking-pro" class="basic-data" method="post">
            <div class="basic view-content">
                <div class="row">
                    <div class="col-sm-6 col-md-6 col-sm-offset-3 col-md-offset-3 form-search">
                        <div class="wrapper-booking-training-form">
                            <h3><?php esc_attr_e('Please select training','wpbookingpro') ?></h3>
                            <div class="block-select-service">
                                <?php if ($booking_style == "in_line") { ?>
                                    <?php echo($form->renderField('service_id')) ?>
                                <?php } ?>
                            </div>
                            <div class="block-select-location">
                                <?php echo($form->renderField('location_id')) ?>
                            </div>
                            <div class="block-select-employee">
                                <?php echo($form->renderField('employee_id')) ?>
                            </div>
                            <div class="controllers">
                                <button class="btn btn-primary btn-get-date-available btn-lg" data-view="1"
                                        type="button"><?php esc_attr_e('Search','wpbookingpro') ?>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6 col-md-6">
                        <div class="pick-date-time" style="display: none">
                            <div class="wrapper-calendar">
                                <div id="calendar" class="calendar"></div>
                                <div class="controllers">
                                    <button class="btn btn-primary btn-back" data-view="1" type="button">
                                        <span>Back</span></button>
                                    <button class="btn btn-danger btn-book-now" style="display:none;" data-view="1"
                                            type="button"><span><?php esc_attr_e('Book now','wpbookingpro') ?></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php if ($booking_style == "in_line") { ?>
                <div class="modal  form-input-info" role="dialog">
                    <div class="modal-dialog modal-lg form-input-info-dialog" role="document">
                        <div class="modal-content form-input-info-content">
                            <div class="modal-header form-input-info-header">
                                <h3 class="modal-title" ><?php esc_attr_e('Booking info','wpbookingpro') ?></h3>
                            </div>
                            <div class="modal-body form-input-info-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="wrapper-service">
                                            <div class="img-box">
                                                <div>
                                                    <img class="service-cover" src="<?php echo Factory::getRootUrlPlugin() . 'assets/images/cover.jpg' ?>" alt="service-cover" />
                                                </div>
                                            </div>
                                            <h4 class="service-name">Vinyasa Yoga</h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="detail-time-and-location">
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <div class="column-title">
                                                <p><?php esc_attr_e('Trainer','wpbookingpro') ?></p>
                                            </div>
                                            <div class="column-content">
                                                <div class="img-box-trainer">
                                                    <div>
                                                        <img class="employee-cover pull-left" src="<?php echo Factory::getRootUrlPlugin() . 'assets/images/employeee.jpg' ?>" alt="employee-cover" />
                                                    </div>
                                                </div>
                                                <p class="employee-name pull-left">Minnie Foss</p>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="column-title">
                                                <p><?php esc_attr_e('Date','wpbookingpro') ?></p>
                                            </div>
                                            <div class="column-content">
                                                <p class="date-detail">December 11, 2019</p>
                                            </div>
                                        </div>
                                        <div class="col-sm-2">
                                            <div class="column-title">
                                                <p><?php esc_attr_e('Local_time','wpbookingpro') ?></p>
                                            </div>
                                            <div class="column-content">
                                                <p class="time-detail">9:00 am</p>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="column-title">
                                                <p><?php esc_attr_e('Location','wpbookingpro') ?></p>
                                            </div>
                                            <div class="column-content">
                                                <p class="location-detail">34th Street</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-customer-info">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="input-firstname">
                                                <?php
                                                $field = $form_booking->getField('first_name');
                                                echo($field->input);
                                                ?>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="input-lastname">
                                                <?php
                                                $field = $form_booking->getField('last_name');
                                                echo($field->input);
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="input-email">
                                                <?php
                                                $field = $form_booking->getField('email');
                                                echo($field->input);
                                                ?>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="input-phone">
                                                <?php
                                                $field = $form_booking->getField('phone');
                                                $field->setId('phone' . rand(700, 30000));
                                                echo($field->input);
                                                ?>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-sm-6">
                                            <p><?php esc_attr_e('Quantity','wpbookingpro') ?></p>
                                            <div class="increment-button">
                                                <?php
                                                $field = $form_booking->getField('number_person');
                                                ?>
                                                <?php echo($field->input) ?>
                                            </div>
                                        </div>
                                        <?php
                                        $field = $form_booking->getField('payment_id');
                                        ?>
                                        <div class="col-sm-6">
                                            <p><?php esc_attr_e('Select payment','wpbookingpro') ?></p>
                                            <?php echo($field->input); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-info-payment">
                                    <div class="row">
                                        <div class="col-sm-6"></div>
                                        <div class="col-sm-6">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="block-payment-item">
                                                        <p><?php esc_attr_e('Payment info','wpbookingpro') ?></p>
                                                        <div class="detail-payment-item">
                                                            <span><?php esc_attr_e('Total number of persons','wpbookingpro') ?>:</span>
                                                            <span class="total-person">1</span>
                                                        </div>
                                                        <div class="detail-payment-item">
                                                            <span><?php esc_attr_e('Base price','wpbookingpro') ?>:</span>
                                                            <span class="base-price"
                                                                  data-price="<?php esc_html_e($item->price) ?>">
                                                                <?php
                                                                echo WpBookingPro_FrontEndHelper::format_currency($item->price)
                                                                ?>
                                                            </span>
                                                        </div>
                                                        <div class="detail-payment-item" style="display: none">
                                                            <span><?php esc_attr_e('Discount','wpbookingpro') ?>:</span>
                                                            <span>$0.00</span>
                                                        </div>
                                                        <div class="add-coupon" style="display: none">
                                                            <span><?php esc_attr_e('Add coupon','wpbookingpro') ?>:</span>
                                                            <div class="add-coupon-input">
                                                                <input type="text" class="coupon_code" />
                                                                <button type="button" class="btn btn-primary"><i
                                                                            class="fas fa-check"></i></button>
                                                            </div>
                                                        </div>
                                                        <div class="detail-payment-item total-cost">
                                                            <span><?php esc_attr_e('Total cost','wpbookingpro') ?>:</span>
                                                            <span class="total-cost-sum">$15.00</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer form-input-info-footer">
                                <button type="button" class="btn btn-primary btn-close-modal" data-dismiss="modal">
                                    <span>Close</span></button>
                                <button type="submit" class="btn btn-danger btn-booking-modal-now">
                                    <span><?php esc_attr_e('Book now','wpbookingpro') ?></span></button>
                                <?php if ($multi_product_in_cart == 1) { ?>
                                    <button class="btn btn-primary btn-add-to-cart" style="display:none;" data-view="1"
                                            type="submit"><span><?php esc_attr_e('Add to cart','wpbookingpro') ?></span>
                                    </button>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
            <input type="hidden" name="service_id" value="<?php esc_html_e($item->id);?>" />
            <input type="hidden" name="task" value="cart.add_to_cart">
        </form>
    </div>

    <?php
    $doc->addScriptApplySelector('.block-bookingtraining-default', 'block_bookingtraining_default', array(
        "link_checkout" => $root_url . "cart/",
        "ajax_url" => admin_url('admin-ajax.php'),
        "booking_style" => $booking_style,
    ), 'blocks/block_bookingtraining/assets/js/jquery.block_bookingtraining_default.js');
} else {
    esc_attr_e('no rate in this product');
}