<?php
WpBookingPro_Html::_('jquery.icheck');

use WooBooking\CMS\Filesystem\Folder;
use WooBooking\CMS\Utilities\Utility;

$root_template = WPBOOKINGPRO_PATH_ROOT . "/dev_tut/template/backend/nb_woobooking";
$doc = Factory::getDocument();
$doc->addLessStylesheet('admin/nb_apps/nb_woobooking/assets/less/view_template.less');
?>
<?php
function tree_view($path)
{
	$folders = Folder::folders($path);
	$files = Folder::files($path);
	ob_start();
	?>
	<?php foreach ($folders as $folder) { ?>
    <li>
		<?php
		$a_root = "$path/$folder";
		?>
        <label> <input type="checkbox" class="node" value="<?php esc_html_e(Utility::get_short_file_by_path($a_root))  ?>" />
            <i class="fas fa-folder"></i>
            <span class="node" data-node_name="<?php esc_html_e($folder) ?>"><?php esc_html_e($folder) ?></span>
        </label>
		<?php if (count(Folder::folders($a_root)) || count(Folder::files($a_root))) { ?>
            <ul>
				<?php echo(tree_view($a_root))  ?>
            </ul>
		<?php } ?>
    </li>
<?php } ?>
	<?php foreach ($files as $file) { ?>
    <li><label> <input type="checkbox" class="node" value="<?php esc_html_e(Utility::get_short_file_by_path("$path/$file"))  ?>">
            <i class="fas fa-file-code"></i>
            <span class="node" data-node_name="<?php esc_html_e($file) ?>"> <?php esc_html_e($file) ?></span>
        </label>
        <span class="view"> <i class="fas fa-eye"></i> <i class="fas fa-eye-slash"></i></span>
    </li>
<?php } ?>
	<?php
	$html = ob_get_clean();
	return $html;
}

?>
    <div class="view-create-template">
        <form>
            <div class="row">
                <div class="col-md-6">
                    <div class="row">
                        <div class="col-md-12">
                        <?php echo($this->form->renderField('view_name')) ?>
                    </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <ul class="tree-node"><?php echo(tree_view($root_template))  ?></ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="code"></div>
                </div>
            </div>
        </form>
    </div>
<?php
$doc->addScriptApplySelector('.view-create-template','view_create_template',array(
),'admin/nb_apps/nb_woobooking/assets/js/view_create_template.js');