<?php
$config=Factory::getAppConfig();
$booking_style=$config->get('booking_style',"in_line");

?>
<div class="view-service-form">
    <form action="#" name="admin-form">
        <div>
            <ul class="service-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active">
                    <a href="#home" aria-controls="home" role="tab" data-toggle="tab">
                        <?php esc_attr_e('Service detail','wpbookingpro') ?>
                    </a>
                </li>
                <li role="presentation">
                    <a href="#profile" aria-controls="profile" role="tab" data-toggle="tab">
                        <?php esc_attr_e('Gallery','wpbookingpro') ?>
                    </a>
                </li>
                <li role="presentation">
                    <a href="#settings" aria-controls="settings" role="tab" data-toggle="tab">
                        <?php esc_attr_e('Settings','wpbookingpro') ?>
                    </a>
                </li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="home">
                    <div class="row">
                        <div class="col-md-12">
                            <?php
                            $field=$this->form->getField('image');
                            ?>
                            <?php echo($field->input) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('name')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('category_id')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('duration')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('price')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('open_time')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('close_time')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('working_day')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('facebook','params')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('instagram','params')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('mobile')) ?>
                        </div>
                    </div>

                    <?php if($booking_style=="integrate"){ ?>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo($this->form->renderField('open_source_link_id')) ?>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('buffer_time_before')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('buffer_time_after')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('minimum_capacity')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('maximum_capacity')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('price_will_multiply')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('location_id')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('rating_ambience')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('rating_cleanliness')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('rating_staff')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('rating_value')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('list_employee_id')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <?php $field = $this->form->getField('bringing_anyone'); ?>
                        <div class="col-md-12">
                            <?php echo($field->input) ?>
                        </div>
                    </div>
                    <div class="row">
                        <?php $field = $this->form->getField('multiply_number'); ?>
                        <div class="col-md-12">
                            <?php echo($field->input) ?>
                        </div>
                    </div>
                    <div class="row">
                        <?php $field = $this->form->getField('published'); ?>
                        <div class="col-md-12">
                            <?php echo($field->input) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('description')) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="profile">
                    <div class="row">
                        <div class="col-md-12">
                            <?php
                            $field=$this->form->getField('gallery');
                            ?>
                            <?php echo($field->input) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="messages">
                    <div class="row">
                        <div class="col-md-12">
                            <?php
                            $field=$this->form->getField('extra');
                            ?>
                            <?php echo($field->input) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="settings">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('disable_payment_online')) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo($this->form->renderField('id')) ?>
    </form>
</div>
