<?php

use WooBooking\CMS\Filesystem\Folder;
use WooBooking\CMS\Utilities\Utility;

WpBookingPro_Html::_('jquery.icheck');
WpBookingPro_Html::_('jquery.bootstrap_tabs');
WpBookingPro_Html::_('jquery.ui');
$doc = Factory::getDocument();
$doc->addScript('resources/js/twbs-pagination/jquery.twbsPagination.js');
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/assets/less/view_list_payment.less');
$list_folder_payment_path = WPBOOKINGPRO_PATH_PLATFORM . "/payments";
$folders = Folder::folders($list_folder_payment_path);
ob_start();
$this->loadTemplate('list_item');
$row_payment_template = ob_get_clean();
?>
    <div class="view-list-payment">
        <div class="toolbar">
            <div class="row">
                <div class="col-md-3"><h3><?php esc_attr_e('List payments','wpbookingpro') ?></h3></div>
                <div class="col-md-9">
                    <div class="pull-right">
                        <button class="btn btn-primary btn-add-new"><i
                                    class="fas fa-plus-square"></i><span><?php esc_attr_e('Add new','wpbookingpro') ?></span></button>
                        <button class="btn btn-primary btn-delete"><i class="fas fa-trash-alt"></i><span><?php esc_attr_e('Delete','wpbookingpro') ?></span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="overflow-x-auto">
            <table class="table  tab-content table-striped table-hover list-payment main-table table-responsive">
                <thead>
                <tr>
                    <th class="nowrap"></th>
                    <th class="nowrap"><i class="fas fa-sort-down"></i></th>
                    <th class="view-list-payment-th nowrap"><?php esc_attr_e('Name','wpbookingpro') ?></th>
                    <th class="view-list-payment-th nowrap"><?php esc_attr_e('Image','wpbookingpro') ?></th>
                    <th class="view-list-payment-th nowrap"><?php esc_attr_e('Payment type','wpbookingpro') ?></th>
                    <th class="view-list-payment-th nowrap"><?php esc_attr_e('ID','wpbookingpro') ?></th>
                    <th class="view-list-payment-th nowrap"><?php esc_attr_e('Status','wpbookingpro') ?></th>
                    <th class="nowrap"></th>
                </tr>
                </thead>
                <tbody class="list-payment main-table">
				<?php foreach ($this->list as $item) { ?>
					<?php $this->item = $item ?>
					<?php $this->loadTemplate('list_item') ?>
				<?php } ?>
                </tbody>
            </table>
        </div>
        <div id="dialog-confirm" class="form-booking" title="<?php esc_attr_e('Form Payment','wpbookingpro') ?> ">
            <div class="modal-header form-input-info-header">
                <h4 class="modal-title" id="gridSystemModalLabel"><?php esc_attr_e('List payments','wpbookingpro') ?></h4>
            </div>
            <div class="modal-body form-input-info-body">
                <ul class="list-folder-payment">
					<?php foreach ($folders as $folder) { ?>
                        <li>
                            <input type="radio" name="payment" id="<?php esc_html_e($folder) ?>" value="<?php esc_html_e($folder) ?>" />
                            <label for="<?php esc_html_e($folder) ?>"><?php esc_html_e($folder) ?></label>
                        </li>
					<?php } ?>
                </ul>
                </br>
            </div>
            <div class="modal-footer form-input-info-footer">
                <button type="button" class="btn btn-secondary btn-close-modal" data-dismiss="modal"><i
                            class="fas fa-window-close"></i><span><?php esc_attr_e('Close','wpbookingpro') ?></span></button>
                <button type="submit" class="btn btn-primary btn-payment-modal-now"><i
                            class="far fa-credit-card"></i><span><?php esc_attr_e('Select','wpbookingpro') ?></span></button>
            </div>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.view-list-payment','view_list_payment',array(
    "row_payment_template"=> $row_payment_template,
    "folders"=>  $folders,
),'admin/nb_apps/nb_woobooking/assets/js/view_list_payment.js');