<?php

use WooBooking\CMS\Utilities\Utility;

WpBookingPro_Html::_('jquery.icheck');
$doc = Factory::getDocument();
$doc->addScript('resources/js/twbs-pagination/jquery.twbsPagination.js');
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/assets/less/view_list_order_status.less');
?>
    <div class="view-list-order_status">
        <form action="#" method="post" name="adminForm" id="adminForm">
            <div class="toolbar">
                <div class="row">
                    <div class="col-md-3"><h3><?php esc_attr_e('List order status','wpbookingpro') ?></h3></div>
                    <div class="col-md-9">
                        <div class="pull-right">
                            <button class="btn btn-primary btn-add-order-status" type="button"><i
                                        class="fas fa-plus-square"></i><span><?php esc_attr_e('Add new','wpbookingpro') ?></span></button>
                            <button class="btn btn-primary btn-delete" type="button"><i
                                        class="fas fa-trash-alt"></i><span><?php esc_attr_e('Delete','wpbookingpro') ?></span></button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="overflow-x-auto">
                <table class="table  tab-content table-striped table-hover list-order_status main-table table-responsive">
                    <thead>
                    <tr>
                        <th class="nowrap"><input type="checkbox" class="checked-all" /></th>
                        <th class="name-order-status nowrap"><?php esc_attr_e('Name','wpbookingpro') ?></th>
                        <th class="id-order-status nowrap"><?php esc_attr_e('ID','wpbookingpro') ?></th>
                        <th class="ordering-order-status nowrap"><?php esc_attr_e('Ordering','wpbookingpro') ?></th>
                        <th class="nowrap"></th>
                    </tr>
                    </thead>
                    <tbody class="list-order_status main-table">
					<?php foreach ($this->list as $item) { ?>
						<?php $this->item = $item ?>
						<?php $this->loadTemplate('list_item') ?>
					<?php } ?>
                    </tbody>
                </table>
            </div>
            <input type="hidden" name="list_order_status_id" />
        </form>
    </div>
<?php
$doc->addScriptApplySelector('.view-list-order_status','view_list_order_status',array(
),'admin/nb_apps/nb_woobooking/assets/js/view_list_order_status.js');