<?php

use WooBooking\CMS\Utilities\Utility;
WpBookingPro_Html::_('jquery.icheck');
$doc = Factory::getDocument();
$doc->addScript('resources/js/twbs-pagination/jquery.twbsPagination.js');
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/assets/less/view_list_category.less');
ob_start();
$this->loadTemplate('list_item');
$row_category_template = ob_get_clean();
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));
$saveOrder = $listOrder == 'a.ordering';
$columns = 10;

if (strpos($listOrder, 'publish_up') !== false) {
    $orderingColumn = 'publish_up';
} elseif (strpos($listOrder, 'publish_down') !== false) {
    $orderingColumn = 'publish_down';
} elseif (strpos($listOrder, 'modified') !== false) {
    $orderingColumn = 'modified';
} else {
    $orderingColumn = 'created';
}

if ($saveOrder) {
    $saveOrderingUrl = 'index.php?option=com_content&task=articles.saveOrderAjax&tmpl=component';
    WpBookingPro_Html::_('sortablelist.sortable', 'articleList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
}


?>

    <div class="view-list-category">
        <form action="#" method="post" name="adminForm" id="adminForm">
            <div class="toolbar">
                <div class="row">
                    <div class="col-md-3"><h3><?php esc_attr_e('List category','wpbookingpro') ?></h3></div>
                    <div class="col-md-9">
                        <div class="pull-right">
                            <button class="btn btn-primary btn-add-new" type="button"><i class="fas fa-plus-square"></i><span><?php esc_attr_e('Add new','wpbookingpro') ?></span></button>
                            <button class="btn btn-primary btn-delete" type="button"><i class="fas fa-trash-alt"></i><span><?php esc_attr_e('Delete') ?></span></button>
                        </div>
                    </div>
                </div>
            </div>


            <div>
                <table class="table  tab-content table-striped table-hover list-category main-table table-responsive">
                    <thead>
                    <tr>
                        <th class="nowrap"><i class="fas fa-sort-down"></i></th>
                        <th class="nowrap"><input type="checkbox" class="checked-all" /></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('Category name','wpbookingpro') ?> </th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('Image','wpbookingpro') ?></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('Access','wpbookingpro') ?></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('Language','wpbookingpro') ?></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('ID','wpbookingpro') ?></th>
                        <th class="nowrap"></th>
                    </tr>
                    </thead>
                    <tbody class="list-category main-table">
                    <?php foreach ($this->list as $item) { ?>
                        <?php $this->item = $item ?>
                        <?php $this->loadTemplate('list_item') ?>
                    <?php } ?>
                    </tbody>
                </table>
            </div>

            <input type="hidden" name="list[ordering]" />
        </form>
    </div>
<?php
$doc->addScriptApplySelector('.view-list-category','view_list_category',array(
    "row_category_template"=>  $row_category_template,
),'admin/nb_apps/nb_woobooking/assets/js/view_list_category.js');