```<?php
$item = $this->item;
?>
<tr class="wrapper-finance-item" data-id="<?php esc_html_e($item->id) ?>">
    <td class="nowrap"><input type="checkbox" class="checkbox-item" data-id="<?php esc_html_e($item->id) ?>" /></td>
    <td class="payment-date nowrap"><?php esc_html_e($item->payment_date) ?></td>
    <td class="name-customer nowrap">
        <p><?php esc_html_e($item->name_customer) ?></p>
        <p><?php esc_html_e($item->email_customer) ?></p>
    </td>
    <td class="employee nowrap">
        <span>
            <img src="<?php esc_html_e(Factory::getRootUrl() . $item->avatar_employee)  ?>" alt="avatar" class="pull-left" />
        </span>
        <span><?php esc_html_e($item->employee) ?></span>
    </td>
    <td class="service nowrap"><?php esc_html_e($item->service) ?></td>
    <td class="status nowrap"><i
                class="fas fa-sync"></i><span><?php echo($item->status == 0 ? 'Pending' : 'Active') ?></span>
    </td>
    <td class="nowrap"><a href="javascript:void(0)" data-id="<?php esc_html_e($item->id) ?>"
           class="btn btn-primary btn-edit-finance"><i class="fas fa-info-circle"></i><span><?php esc_attr_e('Details','wpbookingpro') ?></span></a></td>
    <td class="nowrap"><i class="fas fa-chevron-right arrow-detail-finance"></i></td>
</tr>
<tr class="item-finance-info">
    <td class="nowrap"></td>
    <td class="nowrap">
        <span><?php esc_attr_e('Appointment date','wpbookingpro') ?></span>
        <p></p>
    </td>
    <td colspan="2" class="nowrap"></td>
    <td class="nowrap">
        <span><?php esc_attr_e('Method','wpbookingpro') ?></span>
        <p><i class="fas fa-hand-holding-heart"></i><?php esc_attr_e('On site','wpbookingpro') ?></p>
    </td>
    <td class="nowrap">
        <span><?php esc_attr_e('Amount','wpbookingpro') ?></span>
        <p><?php esc_attr_e('$0.00','wpbookingpro') ?></p>
    </td>
    <td class="nowrap"></td>
    <td class="nowrap"></td>
</tr>