<?php
$item = $this->item;
?>
<tr data-id="<?php esc_html_e($item->id) ?>" class="list-rate-title">
    <td class="nowrap"><input type="checkbox" class="checkbox-item" name="list_delete_event_id[]"  value="<?php esc_html_e($item->id) ?>" /></td>
    <td class="name nowrap"><?php esc_html_e($item->name) ?></td>
    <td class="name nowrap"><?php esc_html_e($item->total_order) ?></td>
    <td class="nowrap"><?php esc_html_e(@$item->total_person) ?>/<?php esc_html_e($item->max_allowed_person) ?></td>
    <td class="nowrap"><?php esc_html_e($item->min_allowed_person) ?>-<?php esc_html_e($item->max_allowed_person) ?></td>
    <td class="recurring">
        <?php if(isset($item->recurring)) {?>
            <i class="fas fa-sync-alt"></i> <span><?php esc_attr_e('Yes','wpbookingpro')?></span>
        <?php } else {?>
            <i class="fas fa-sync-alt"></i> <span><?php esc_attr_e('No','wpbookingpro')?></span>
        <?php }?>
    </td>
    <td class="open_date nowrap"><?php esc_html_e(WpBookingPro_Html::_('date', isset($item->open_date)?$item->open_date:"",
			WoobookingText::_('DATETIME_FORMAT_1'))); ?></td>
    <td class="close_date nowrap"><?php esc_html_e(WpBookingPro_Html::_('date', isset($item->close_date)?$item->close_date:"",
			WoobookingText::_('DATETIME_FORMAT_1'))); ?></td>
    <td class="published">
        <?php if(isset($item->published)) {?>
            <span class="label label-success"><?php esc_attr_e('Open','wpbookingpro')?></span>
        <?php } else {?>
            <span class="label label-danger"><?php esc_attr_e('Close','wpbookingpro')?></span>
        <?php }?>
    </td>
    <td class="item-id nowrap"><?php esc_html_e($item->id) ?></td>
    <td>
        <a href="javascript:void(0)" data-id="<?php esc_html_e($item->id) ?>" class="btn btn-primary btn-edit-event">
            <i class="far fa-edit"></i> <?php esc_attr_e('Edit','wpbookingpro') ?>
        </a>
    </td>
    <td>
        <button type="button" class="btn btn-primary btn-show-rate"><i class="fas fa-sort-down btn-show-rate-detail"></i></button>
    </td>
</tr>
<tr class="list-rate-info list-rate-info-<?php esc_html_e($item->id); ?>">
    <th class="nowrap"></th>
    <th class="nowrap"><?php esc_attr_e('ID','wpbookingpro')?></th>
    <th class="nowrap"><?php esc_attr_e("Total order",'wpbookingpro') ?></th>
    <th class="nowrap"><?php esc_attr_e('Spots','wpbookingpro')?></th>
    <td colspan="2" class="nowrap"></td>
    <th class="nowrap"><?php esc_attr_e('From','wpbookingpro')?></th>
    <th class="nowrap"><?php esc_attr_e('To','wpbookingpro')?></th>
    <th colspan="4" class="nowrap"></th>
</tr>
<?php if (count((array)$item->list_rate)) { ?>
	<?php foreach ((array)$item->list_rate as $rate) { ?>
        <tr class="list-rate-info list-rate-info-<?php esc_html_e($item->id); ?>">
            <td class="nowrap"></td>
            <td class="nowrap"><?php esc_html_e($rate->id); ?></td>
            <td class="nowrap"><?php esc_html_e($rate->total_order_per_rate); ?></td>
            <td class="nowrap"><?php esc_html_e($rate->total_person_per_rate ? $rate->total_person_per_rate : 0); ?></td>
            <td colspan="2" class="nowrap"></td>
            <td class="nowrap"><?php esc_html_e(WpBookingPro_Html::_('date', $rate->from,
					WoobookingText::_('DATETIME_FORMAT_1'))); ?></td>
            <td class="nowrap"><?php esc_html_e(WpBookingPro_Html::_('date', $rate->to,
					WoobookingText::_('DATETIME_FORMAT_1'))); ?></td>
            <td colspan="4" class="nowrap">
            </td>
        </tr>
	<?php } ?>
<?php } ?>
