<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_DashboardView")) {
    /**
     * Class WpBookingPro_DashboardView
     */
    class WpBookingPro_DashboardView extends WooBookingView
    {
        /**
         * @var
         */
        public $item;
        /**
         * @var array
         */
        public $list_order_by_month = array();

        /**
         * @param null $tpl
         * @return false|string
         * @throws Exception
         */
        public function display($tpl = null)
        {
            $modelCustomer = $this->getModel('wbcustomer');
            $input = Factory::getInput();
            switch ($tpl) {
                case "item":
                    $id = 2;
                    $this->item = $modelCustomer->getItem($id);
                    $this->form = $modelCustomer->getForm();
                    break;
                case "form":
                    $id = $input->getInt('id', 0);
                    $this->item = $modelCustomer->getItem($id);
                    $this->form = $modelCustomer->getForm();
                    break;
                    break;
                case "list":
                default:
                    $tpl = "list";
                    $modelCustomers = $this->getModel('customers');
                    $this->list_customer = $modelCustomers->get_list_customer_in_year();

                    $modelCategories = $this->getModel('categories');
                    $this->list_category = $modelCategories->getList();

                    $modelOrders = WoobookingModel::getInstance('orders');
                    $list_order_in_year = $modelOrders->get_list_order_in_year();
                    $list_order_by_month = array();
                    foreach ($list_order_in_year as $item) {
                        $list_order_by_month[$item->month][] = $item;
                    }


                    $now = Factory::getDate();
                    $month = (int)$now->format('m');
                    $list_full_order_year = array();
                    for ($i = $month; $i < $month + 12; $i++) {
                        {
                            $j = $i;
                            if ($j > 12) {
                                $j = $j - 12;
                            }
                            $key = "month $j";
                            if (isset($list_order_by_month[$j])) {
                                $list_full_order_year[$key] = $list_order_by_month[$j];
                            } else {
                                $list_full_order_year[$key] = array();
                            }
                        }
                    }
                    $this->list_order_by_month = $list_full_order_year;
                    $this->list_order_in_year = $list_order_in_year;

                    break;
            }
            return parent::display($tpl);
        }
    }
}