<?php

use WooBooking\CMS\Utilities\Utility;

$doc = Factory::getDocument();
WpBookingPro_Html::_('jquery.bootstrap');
WpBookingPro_Html::_('jquery.chart_js');
WpBookingPro_Html::_('jquery.bootstrap_tabs');
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/assets/less/view_db_appointments_dashboard.less');
$number_user= count($this->list_customer);
$number_month=count($this->list_order_by_month);
$number_month_order=count($this->list_order_by_month,1);
$number_category=count($this->list_category);
$number_oder= $number_month_order - $number_month;
$total=0;
?>
    <div class="view-db-appointments-dashboard">
        <h2 class="title"><i class="fab fa-buromobelexperte"></i> <?php esc_attr_e('Wpbookingpro','wpbookingpro') ?></h2>
        <div class="row">
            <div class="col-md-3">
                <div class="block-item-widget user">
                    <div class="icon-block">
                        <i class="fas fa-user-friends"></i>
                    </div>
                    <div class="content-block">
                        <h4> <?php esc_attr_e('New users','wpbookingpro') ?></h4>
                        <p><?php esc_html_e($number_user); ?> <?php esc_attr_e('New users','wpbookingpro') ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="block-item-widget order">
                    <div class="icon-block">
                        <i class="fas fa-cart-plus"></i>
                    </div>
                    <div class="content-block">
                        <h4><?php esc_attr_e('New order','wpbookingpro') ?></h4>
                        <p><?php esc_html_e($number_oder);  ?> <?php esc_attr_e('New order','wpbookingpro') ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="block-item-widget delivery">
                    <div class="icon-block">
                        <i class="fas fa-shopping-bag"></i>
                    </div>
                    <div class="content-block">
                        <h4><?php esc_attr_e('Category','wpbookingpro') ?></h4>
                        <p><?php esc_html_e($number_category);  ?> <?php esc_attr_e('Category','wpbookingpro') ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="block-item-widget monthly">
                    <div class="icon-block">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="content-block">
                        <?php foreach ($this->list_order_in_year as $item) { ?>
                            <?php $total += $item->total ?>
                        <?php } ?>
                        <h4><?php esc_attr_e('Yearly profits','wpbookingpro') ?></h4>
                        <p><?php esc_html_e(WpBookingPro_Helper::format_currency($total)); ?> <?php esc_attr_e('This year','wpbookingpro') ?></p>
                    </div>
                </div>
            </div>

        </div>
        <div class="total-order">
            <h3><?php esc_attr_e('Total order','wpbookingpro') ?></h3>
            <canvas class="order-this-week"></canvas>
        </div>
        <div class="monthly-profits">
            <h3><?php esc_attr_e('Month profits','wpbookingpro') ?></h3>
            <canvas class="employee-chart"></canvas>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="new-customer">
                    <h3><?php esc_attr_e('New customer','wpbookingpro') ?></h3>
                    <table class="table table-responsive">
                        <thead>
                        <tr>
                            <th class="nowrap"><?php esc_attr_e('ID','wpbookingpro') ?></th>
                            <th class="nowrap"><?php esc_attr_e('Name','wpbookingpro') ?></th>
                            <th class="nowrap"><?php esc_attr_e('Phone','wpbookingpro') ?></th>
                            <th class="nowrap"><?php esc_attr_e('Order time','wpbookingpro') ?> </th>
                        </tr>
                        </thead>
                        <tbody class="list-wbcustomer main-table">
                        <?php foreach ($this->list_customer as $item) { ?>
                            <?php $this->item = $item ?>
                            <?php $this->loadTemplate('list_item_customer') ?>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-md-6">
                <div class="list-category">
                    <h3><?php esc_attr_e('List category','wpbookingpro') ?></h3>
                    <table class="table table-responsive">
                        <thead>
                        <tr>
                            <th class="view-list-category-th nowrap"><?php esc_attr_e('ID','wpbookingpro') ?></th>
                            <th class="view-list-category-th nowrap"><?php esc_attr_e('Name','wpbookingpro') ?></th>
                            <th class="view-list-category-th nowrap"><?php esc_attr_e('Image','wpbookingpro') ?></th>
                        </tr>
                        </thead>
                        <tbody class="list-category main-table">
                        <?php foreach ($this->list_category as $item) { ?>
                            <?php $this->item = $item ?>
                            <?php $this->loadTemplate('list_item_category') ?>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.view-db-appointments-dashboard','view_db_appointments_dashboard',array(
    "list_order_by_month"=>$this->list_order_by_month
),'admin/nb_apps/nb_woobooking/assets/js/view_db_appointments_dashboard.js');