<?php
$doc = Factory::getDocument();
$doc->addScript('resources/js/twbs-pagination/jquery.twbsPagination.js');
$doc->addScript('admin/nb_apps/nb_woobooking/assets/js/view_list_event.js');
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/assets/less/view_list_event.less');
?>
<div class="view-list-event">
    <div class="toolbar">
        <div class="row">
            <div class="col-md-3"><h3><?php esc_attr_e('List event','wpbookingpro')?></h3></div>
            <div class="col-md-9">
                <div class="pull-right">
                    <button class="btn btn-primary btn-add-new"><?php esc_attr_e('Add new','wpbookingpro')?></button>
                    <button class="btn btn-primary btn-delete"><?php esc_attr_e('Delete','wpbookingpro')?></button>
                </div>
            </div>
        </div>
    </div>
    <div class="filter">
        <div class="row">
            <div class="col-md-12">
                <?php
                esc_html_e(LayoutHelper::render('WooBooking.searchtools.default', array('view' => $this)));
                ?>
            </div>
        </div>
    </div>
    <div>
        <table class="table table-bordered tab-content table-striped table-hover list-event main-table table-responsive">
            <thead>
            <tr>
                <th class="nowrap"><?php esc_attr_e('Name','wpbookingpro')?></th>
                <th class="nowrap"><?php esc_attr_e('Spots','wpbookingpro')?></th>
                <th class="nowrap"><?php esc_attr_e('Recurring','wpbookingpro')?></th>
                <th class="nowrap"><?php esc_attr_e('Booking open','wpbookingpro')?></th>
                <th class="nowrap"><?php esc_attr_e('Booking close','wpbookingpro')?></th>
                <th class="nowrap"><?php esc_attr_e('Status','wpbookingpro')?></th>
                <th class="nowrap"></th>
                <th class="nowrap"></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($this->list as $item) { ?>
                <?php $this->item = $item ?>
                <?php $this->loadTemplate('list_item') ?>
            <?php } ?>
            </tbody>
        </table>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="pagination-list-event"></div>
        </div>
    </div>
</div>