<?php

use WooBooking\CMS\Utilities\Utility;

$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_list_service.less');
?>
<div class="view-list-service">
    <h3><?php esc_attr_e('Service','wpbookingpro') ?></h3>
    <div class="row">
		<? foreach ($this->list as $item) { ?>
            <div class="col-md-4">
                <div class="wrapper-service-item">
                    <div class="layer-grey">
                        <div class="title-service-item"><?php esc_html_e($item->name); ?></div>
                        <a href="<?php esc_html_e($this->goToLink("service.detail", "service_id=" . $item->id)) ?>"
                           class="btn btn-outline-secondary view-more"><?php esc_attr_e('View more','wpbookingpro') ?></a>
                    </div>
                    <div class="layer-content">
                        <div class="block-img"
                             style="background-image: url('<?php esc_html_e(Factory::getRootUrlPlugin())  ?>/<?php esc_html_e($item->service_image_intro); ?>')"></div>
                        <div class="block-content">
                            <div class="avatar-service-item">
                                <span><?php
									$name = $item->name;
									$name = Utility::clean($name);
									$name = Utility::clean_all_space_to_single_space($name);
									$arrName = explode(' ', $name);
									$arrName = array_splice($arrName, 0, 3);
									$result = '';
									foreach ($arrName as $value) {
										$result .= substr($value, 0, 1);
									}
									esc_html_e($result);
									?></span>
                            </div>
                            <h3><a href="<?php  esc_html_e($this->goToLink("service.detail",
									"service_id=" . $item->id)) ?>"><?php esc_html_e($item->name); ?></a></h3>
                            <p><?php esc_attr_e('Price','wpbookingpro') ?>
                                : <?php esc_html_e(WpBookingPro_FrontEndHelper::format_currency($item->price))  ?></p>
                            <div class="img-avatar-employee">
								<?php foreach ($item->list_employee as $list_employee) { ?>
                                    <div class="img-box">
                                        <img src="<?php esc_html_e(Factory::getRootUrlPlugin())  ?>/<?php esc_html_e($list_employee->image); ?>" alt="avatar-employee" />
                                    </div>
								<?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		<?php } ?>
    </div>
</div>