<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_OrderDetailModel")) {
    /**
     * Class WpBookingPro_OrderDetailModel
     */
    class WpBookingPro_OrderDetailModel extends WoobookingModelForm
    {
        /**
         * @var string
         */
        public $table_name = "OrderDetail";
        /**
         * @var string
         */
        public $context = "OrderDetail";

        /**
         * @param int $id
         * @return mixed
         */
        public function getItem($id = 0)
        {
            $db = Factory::getDBO();
            $query = $db->getQuery(true)
                ->select("order_detail.*")
                ->from($this->getTableName('order_detail') . ' AS order_detail')
                ->leftJoin($this->getTableName('order_detail_rate') . ' AS order_detail_rate ON order_detail_rate.order_detail_id=order_detail.id')
                ->select('order_detail_rate.start_date,order_detail_rate.end_date')
                ->where("order_detail.id=" . (int)$id);
            $item = $db->setQuery($query)->loadObject();
            $item->rates = [
                (object)[
                    "from" => $item->start_date,
                    "to" => $item->end_date
                ]
            ];
            return $item;
        }
    }
}