<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Utilities\Utility;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('jquery.tooltipster');
WpBookingPro_Html::_('jquery.select_yes_no');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_of_field = str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>"
         class="<?php esc_html_e($class); ?> field-yesno-<?php esc_html_e($name_of_field) ?> field-yesno">
        <div class="form-control">
            <label class="label col-md-8"><?php esc_html_e($label) ?>
                <span class="tooltipster" class="fas fa-question-circle"></span>
            </label>
            <div class="col-md-4">
                <input class="form-check-input yes-no pull-right" <?php esc_html_e($value == 1 ? ' checked ' : "unchecked") ?> type="checkbox" />
                <input class="" name="<?php esc_html_e($name); ?>" type="hidden" value="<?php esc_html_e($value) ?>" />
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/yesno.less');
$doc->addScriptApplySelector('.field-yesno-'.$name_of_field,'field_yesno',array(
    "field_name"=>  $name,
),
    'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/yesno.jquery.js');