(function ($) {
    $.field_workhours = function (element, options) {
        var defaults = {
            template_body_of_day: '',
            template_footer_of_day: '',
            input_name: "",
            list_service: [],
            list_location: []
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element), 
            element = element;    
        plugin.updateData = function () {
            let input_name = plugin.settings.input_name;
            let list_data = [];
            let $list_tr = $element.find('.category-and-service');
            $list_tr.each(function (e) {
                let $tr = $(this);
                let item_data = {
                    service_id: $tr.data('service_id'),
                    enable_customize: $tr.find('.enable-customize').is(':checked'),
                    price: $tr.find('input.price').autoNumeric('get'),
                    minimum_capacity: $tr.find('input.minimum_capacity').val(),
                    maximum_capacity: $tr.find('input.maximum_capacity').val()
                };
                list_data.push(item_data);
            });
            let base64data = $.base64('encode', JSON.stringify(list_data));
            $element.find(`input[name="${input_name}"]`).val(base64data);
        };
        plugin.cancel_range_time = function ($wrapper_workhours_item) {
            $wrapper_workhours_item.find('.body').empty();
        };
        plugin.validate_range_time = function ($wrapper_workhours_item) {
            let time_start = $wrapper_workhours_item.find('select.list-time-start').val();
            let time_end = $wrapper_workhours_item.find('select.list-time-end').val();
            let service = $wrapper_workhours_item.find('select.list-service').val();
            let location = $wrapper_workhours_item.find('select.list-location').val();
            if (time_start === "") {
                $.alert({
                    title: 'Error',
                    content: 'please select start time',
                });
                return false;
            }
            if (time_end === "") {
                $.alert({
                    title: 'Error',
                    content: 'please select end time',
                });
                return false;
            }
            if (typeof service === "undefined" || service === null || service === "") {
                $.alert({
                    title: 'Error',
                    content: 'please select service',
                });
                return false;
            }
            if (typeof location === "undefined" || location === null || location === "") {
                $.alert({
                    title: 'Error',
                    content: 'please select location',
                });
                return false;
            }
            return true;
        };
        plugin.get_full_time = function (time_start, time_end) {
            let sub_get_time = function (time) {
                let $kq = (time * 10) % 10;
                let $t = "";
                if ($kq === 0) {
                    if (time < 10)
                        $t = `0${time}:00`;
                    else {
                        $t = `${time}:00`;
                    }
                } else {
                    if (time < 10)
                        $t = `0${Math.floor(time)}:30`;
                    else {
                        $t = `${Math.floor(time)}:30`;
                    }
                }
                return $t;
            };
            let t1 = sub_get_time(time_start);
            let t2 = sub_get_time(time_end);
            return `${t1} - ${t2}`;
        };
        plugin.save_range_time = function ($wrapper_workhours_item) {
            if (!plugin.validate_range_time($wrapper_workhours_item)) {
                return false;
            }
            let time_start = $wrapper_workhours_item.find('select.list-time-start').val();
            let time_end = $wrapper_workhours_item.find('select.list-time-end').val();
            let list_service_id = $wrapper_workhours_item.find('select.list-service').val();
            let location_id = $wrapper_workhours_item.find('select.list-location').val();
            let list_location = plugin.settings.list_location;
            let list_service = plugin.settings.list_service;
            let list_str_service = [];
            $.each(list_service_id, function (index, service_id) {
                list_str_service.push(list_service[service_id].name);
            });
            let $template_footer_of_day = $(plugin.settings.template_footer_of_day);
            $template_footer_of_day.find('span.time').html(plugin.get_full_time(time_start, time_end));
            $template_footer_of_day.find('span.location').html(list_location[location_id].address);
            $template_footer_of_day.find('span.list-service').html(list_str_service.join(","));
            $wrapper_workhours_item.find('.footer').append($template_footer_of_day);
            $template_footer_of_day.find('.edit-range-time').click(function (e) {
                plugin.edit_range_time_to_day($wrapper_workhours_item);
            });
            $wrapper_workhours_item.find('.body').empty();
        };
        plugin.add_range_time_to_day = function ($wrapper_workhours_item) {
            if ($wrapper_workhours_item.find('.body-content').length > 0) {
                return false;
            }
            let $template_body_of_day = $(plugin.settings.template_body_of_day);
            
            $template_body_of_day.find(".btn-cancel-range-time").click(function (e) {
                let $wrapper_workhours_item = $(this).closest('.wrapper-workhours-item');
                plugin.cancel_range_time($wrapper_workhours_item);
            });
            $template_body_of_day.find(".btn-save-range-time").click(function (e) {
                let $wrapper_workhours_item = $(this).closest('.wrapper-workhours-item');
                plugin.save_range_time($wrapper_workhours_item);
            });
            $wrapper_workhours_item.find('.body').append($template_body_of_day);
            $template_body_of_day.find('input[type="radio"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%' 
            });
            $template_body_of_day.find('input[type="radio"]').on('ifChecked', function (e) {
                $template_body_of_day.find('.row-work-hours').toggle("slow", function () {
                    
                });
                $template_body_of_day.find('.row-breaks').toggle("slow", function () {
                    
                });
            });
            $template_body_of_day.find('select.list-service').select2();
            $template_body_of_day.find('select.list-location').select2();
            $template_body_of_day.find('select.list-time-start').select2();
            $template_body_of_day.find('select.list-time-end').select2();
        };
        plugin.edit_range_time_to_day = function ($wrapper_workhours_item) {
            if ($wrapper_workhours_item.find('.body-content').length > 0) {
                return false;
            }
            let $template_body_of_day = $(plugin.settings.template_body_of_day);
            
            $template_body_of_day.find(".btn-cancel-range-time").click(function (e) {
                let $wrapper_workhours_item = $(this).closest('.wrapper-workhours-item');
                plugin.cancel_range_time($wrapper_workhours_item);
            });
            $template_body_of_day.find(".btn-save-range-time").click(function (e) {
                let $wrapper_workhours_item = $(this).closest('.wrapper-workhours-item');
                plugin.save_range_time($wrapper_workhours_item);
            });
            $wrapper_workhours_item.find('.body').append($template_body_of_day);
            $template_body_of_day.find('input[type="radio"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%' 
            });
            $template_body_of_day.find('input[type="radio"]').on('ifChecked', function (e) {
                $template_body_of_day.find('.row-work-hours').toggle("slow", function () {
                    
                });
                $template_body_of_day.find('.row-breaks').toggle("slow", function () {
                    
                });
            });
            $template_body_of_day.find('select.list-service').select2();
            $template_body_of_day.find('select.list-location').select2();
            $template_body_of_day.find('select.list-time-start').select2();
            $template_body_of_day.find('select.list-time-end').select2();
        }
        
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.add-range-time').click(function (e) {
                let $wrapper_workhours_item = $(this).closest('.wrapper-workhours-item');
                plugin.add_range_time_to_day($wrapper_workhours_item);
            });
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    
    $.fn.field_workhours = function (options) {
        
        return this.each(function () {
            
            if (undefined == $(this).data('field_workhours')) {
                var plugin = new $.field_workhours(this, options);
                $(this).data('field_workhours', plugin);
            }
        });
    }
})(jQuery);