<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('jquery.dateselect');
WpBookingPro_Html::_('jquery.select2');
WpBookingPro_Html::_('script', 'system/html5fallback.js',
	array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/assets/less/wordpressuser.less');
$list_open_source_user = get_users();
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="field-wordpress_user">
        <select class="open-source-user" name="<?php esc_html_e($name); ?>">
            <option value=""><?php esc_attr_e('None','wpbookingpro') ?></option>
			<?php foreach ($list_open_source_user as $user) { ?>
                <option <?php echo($value == $user->get('id') ? ' selected ' : '') ?>
                        value="<?php esc_html_e($user->get('id')) ?>"><?php esc_html_e($user->get('user_login')) ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc->addScriptApplySelector('.field-wordpress_user','field_wordpress_user',array(
    "input_name"=>  $name,
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/wordpressuser.jquery.js');
