<?php
use WooBooking\CMS\Utilities\Utility;
defined('WPBOOKINGPRO_PATH_BASE') or die;
extract($displayData);

$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$list_selected = $value;
$list_view = WpBookingPro_Helper::function_get_view();
WpBookingPro_Html::_('jquery.icheck');
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-views">
        <ul class=" list-view">
			<?php foreach ($list_view as $view) { ?>
                <li value="">
                    <label><input type="checkbox" <?php echo($view->is_system) || in_array($view->menu_slug,
							$list_selected) ? ' checked ' : '' ?> <?php echo($view->is_system ? ' disabled ' : '') ?>
                                  name="<?php esc_html_e($name); ?>[]"
                                  value="<?php esc_html_e($view->menu_slug); ?>"> <?php esc_html_e($view->label); ?>
                    </label>
                </li>
			<?php } ?>
        </ul>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/views.less');
$doc->addScriptApplySelector('.field-views','field_views',array(
    "field_name"=>  $name,
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/views.jquery.js');
