<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('jquery.select2');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$modelCategories = WoobookingModel::getInstance('categories');
$list = $modelCategories->getList();
$list_time = [];
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-servicecategory">
        <select name="<?php esc_html_e($name); ?>" <?php echo($multiple ? ' multiple ' : '')  ?>
                class="list-servicecategory">
            <option value=""><?php esc_attr_e('Select category','wpbookingpro') ?></option>
			<?php foreach ($list as $item) { ?>
                <option <?php echo($item->id == $value ? ' selected ' : ''); ?>
                        value="<?php esc_html_e($item->id); ?>"><?php esc_html_e($item->name); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/servicecategory.less');
$doc->addScriptApplySelector('.field-servicecategory','field_servicecategory',array(
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/servicecategory.jquery.js');