<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$list = '';
if ($options) {
    $list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
    !empty($class) ? 'class="' . $class . '"' : '',
    !empty($size) ? 'size="' . $size . '"' : '',
    $disabled ? 'disabled' : '',
    $readonly ? 'readonly' : '',
    $list,
    strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
    $onchange ? ' onchange="' . $onchange . '"' : '',
    !empty($maxLength) ? $maxLength : '',
    $required ? 'required aria-required="true"' : '',
    $autocomplete,
    $autofocus ? ' autofocus' : '',
    $spellcheck ? '' : 'spellcheck="false"',
    !empty($inputmode) ? $inputmode : '',
    !empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="field-rating">
        <div class="wrapper-rating">
            <input type="text" class="form-control rating" value="<?php esc_html_e($value) ?>" <?php echo(implode(' ', $attributes)); ?> />
            <input type="hidden" name="<?php esc_html_e($name); ?>" value="<?php esc_html_e($value) ?>" />
        </div>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingPro_Html::_('jquery.auto_numeric');
$doc->addScriptApplySelector("#$id_by_name",'field_rating',array(
    "input_name"=>  $name,
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/rating/jquery.rating.js');
