<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.ui');
WpBookingPro_Html::_('jquery.select2');
WpBookingPro_Html::_('jquery.fontawesome');
WpBookingPro_Html::_('jquery.moment');
WpBookingPro_Html::_('jquery.daterangepicker');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/rate.less');
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$list_rate = (array)$value;


$template_range_date = function ($name, $from, $to, $required) {
	$from = Factory::getDate($from);
	if (!$from->getTimestamp()) {
		$from = clone Factory::getDate();
	}
	$from = $from->toSql();
	$to = Factory::getDate($to);
	if (!$to->getTimestamp()) {
		$to = clone  Factory::getDate();
	}
	$to = $to->toSql();
	ob_start();
	?>
    <div class="item">
        <div class="input-rate">
            <input type="text" class="form-control m-input rate" value="<?php esc_html_e($from && $to ? "$from;$to" : '') ?>"/>
        </div>
        <div class="controllers">
            <button type="button" class="btn btn-add btn-primary pull-left"><i class="far fa-copy"></i>
            </button>
            <button type="button" class="btn btn-close-item btn-primary pull-left"><i
                        class="far fa-trash-alt"></i></button>
        </div>
        <input type="hidden" class="rates" value="<?php esc_html_e($from && $to ? "$from;$to" : '') ?>" name="<?php esc_html_e($name); ?>[]" />
    </div>
	<?php
	return ob_get_clean();
};
$item_rate = '';
$max_rate = $max_rate ? $max_rate : 10
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-input-rate">
        <div class="list-item">
            <?php if (count($list_rate)==0) {
                echo($template_range_date($name, null, null, $required));
            } else { ?>
                <?php foreach ($list_rate as $key => $rate) {
                    echo($template_range_date($name, $rate->from, $rate->to, $required));
                } ?>
            <?php } ?>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.field-input-rate','field_rate',array(
    "item_rate"=>  $template_range_date($name, "", "", $required),
    "input_name"=>  $name.'[]',
    "max_rate"=>  $max_rate,
    "values"=>  $value,
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/rate.jquery.js');
