<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('jquery.dateselect');
WpBookingPro_Html::_('script', 'system/html5fallback.js',
	array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$doc = Factory::getDocument();


$doc->addLessStylesheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/mediabrowser.less');
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_of_field = str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="field-mediabrowser-<?php esc_html_e($name_of_field) ?>">
        <div class="show-image"><img class="media-show" src="<?php esc_html_e($value) ?>" alt="media-show" /></div>
        <div class="input-group">
            <input type="text" class="form-control" name="<?php esc_html_e($name); ?>" value="<?php esc_html_e($value) ?>"   />
            <span class="input-group-btn">
        <button class="btn btn-default btn-browser-media" type="button"><?php esc_attr_e('Browser','wpbookingpro') ?></button>
      </span>
        </div><!-- /input-group -->
    </div>
<?php
$doc->addScriptApplySelector('.field-mediabrowser-'.$name_of_field,'field_mediabrowser',array(
    "input_name"=>  $name,
    "multiple"=>  $multiple,
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/mediabrowser.jquery.js');
