<?php

defined('_WPBOOKINGPRO_EXEC') or die;

extract($displayData);

WpBookingPro_Html::_('behavior.modal');

WpBookingPro_Html::_('jquery.framework');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/assets/less/media.less');
WpBookingPro_Html::_('script', 'media/mediafield-mootools.min.js',
	array('version' => 'auto', 'relative' => true, 'framework' => true));

$options = array(
	'onShow' => 'jMediaRefreshImgpathTip',
);
WpBookingPro_Html::_('behavior.tooltip', '.hasTipImgpath', $options);
if (!empty($class)) {
	$class .= ' hasTipImgpath';
} else {
	$class = 'hasTipImgpath';
}
$attr = '';
$attr .= ' title="' . htmlspecialchars('<span id="TipImgpath"></span>', ENT_COMPAT, 'UTF-8') . '"';

$attr .= !empty($class) ? ' class="input-small field-media-input ' . $class . '"' : ' class="input-small"';
$attr .= !empty($size) ? ' size="' . $size . '"' : '';

$attr .= !empty($onchange) ? ' onchange="' . $onchange . '"' : '';

echo '<div class="input-prepend input-append">';

$showPreview = true;
$showAsTooltip = false;
switch ($preview) {
	case 'no':
	case 'false':
	case 'none':
		$showPreview = false;
		break;
	case 'yes':
	case 'true':
	case 'show':
		break;
	case 'tooltip':
	default:
		$showAsTooltip = true;
		$options = array(
			'onShow' => 'jMediaRefreshPreviewTip',
		);
		WpBookingPro_Html::_('behavior.tooltip', '.hasTipPreview', $options);
		break;
}

if ($showPreview) {
	if ($value && file_exists(WPBOOKINGPRO_PATH_ROOT . '/' . $value)) {
		$src = JUri::root() . $value;
	} else {
		$src = '';
	}
	$width = $previewWidth;
	$height = $previewHeight;
	$style = '';
	$style .= ($width > 0) ? 'max-width:' . $width . 'px;' : '';
	$style .= ($height > 0) ? 'max-height:' . $height . 'px;' : '';
	$imgattr = array(
		'id' => $id . '_preview',
		'class' => 'media-preview',
		'style' => $style,
	);
	$img = WpBookingPro_Html::_('image', $src, WoobookingText::_('JLIB_FORM_MEDIA_PREVIEW_ALT'), $imgattr);
	$previewImg = '<div id="' . $id . '_preview_img"' . ($src ? '' : ' style="display:none"') . '>' . $img . '</div>';
	$previewImgEmpty = '<div id="' . $id . '_preview_empty"' . ($src ? ' style="display:none"' : '') . '>'
		. WoobookingText::_('JLIB_FORM_MEDIA_PREVIEW_EMPTY') . '</div>';
	if ($showAsTooltip) {
		echo '<div class="media-preview add-on">';
		$tooltip = $previewImgEmpty . $previewImg;
		$options = array(
			'title' => WoobookingText::_('JLIB_FORM_MEDIA_PREVIEW_SELECTED_IMAGE'),
			'text' => '<span class="icon-eye" aria-hidden="true"></span>',
			'class' => 'hasTipPreview'
		);
		echo WpBookingPro_Html::_('tooltip', $tooltip, $options);
		echo '</div>';
	} else {
		echo '<div class="media-preview add-on">';
		echo ' ' . $previewImgEmpty;
		echo ' ' . $previewImg;
		echo '</div>';
	}
}
echo '	<input type="text" name="' . $name . '" id="' . $id . '" value="'
	. htmlspecialchars($value, ENT_COMPAT, 'UTF-8') . '" readonly="readonly"' . $attr . ' data-basepath="'
	. JUri::root() . '"/>';
?>
<a class="modal btn" title="<?php esc_attr_e('JLIB_FORM_BUTTON_SELECT','wpbookingpro'); ?>" href="
<?php echo ($readonly ? ''
		: ($link ?: 'index.php?option=com_media&amp;view=images&amp;tmpl=component&amp;asset=' . $asset . '&amp;author='
			. $authorField) . '&amp;fieldid=' . $id . '&amp;folder=' . $folder) . '"'
	. ' rel="{handler: \'iframe\', size: {x: 800, y: 500}}"'; ?>>
 <?php echo WoobookingText::_('JLIB_FORM_BUTTON_SELECT'); ?></a><a class=" btn
   hasTooltip" title="<?php esc_attr_e('JLIB_FORM_BUTTON_CLEAR','wpbookingpro'); ?>" href="#" onclick="jInsertFieldValue('', '<?php esc_attr_e($id); ?>'); return false;">
<span class="icon-remove" aria-hidden="true"></span></a>
</div>