<?php

defined('_WPBOOKINGPRO_EXEC') or die;

use WooBooking\Utilities\ArrayHelper;

extract($displayData);

$document = Factory::getDocument();

$inputvalue = '';

$attributes = array();
empty($size) ? null : $attributes['size'] = $size;
empty($maxlength) ? null : $attributes['maxlength'] = ' maxlength="' . $maxLength . '"';
empty($class) ? null : $attributes['class'] = $class;
!$readonly ? null : $attributes['readonly'] = 'readonly';
!$disabled ? null : $attributes['disabled'] = 'disabled';
empty($onchange) ? null : $attributes['onchange'] = $onchange;
if ($required) {
	$attributes['required'] = '';
	$attributes['aria-required'] = 'true';
}

if (strtoupper($value) == 'NOW') {
	$value = Factory::getDate()->format('Y-m-d H:i:s');
}
$readonly = isset($attributes['readonly']) && $attributes['readonly'] == 'readonly';
$disabled = isset($attributes['disabled']) && $attributes['disabled'] == 'disabled';
if (is_array($attributes)) {
	$attributes = ArrayHelper::toString($attributes);
}
$cssFileExt = ($direction === 'rtl') ? '-rtl.css' : '.css';

WpBookingPro_Html::_('behavior.polyfill', array('event', 'classlist', 'map'), 'lte IE 11');

WpBookingPro_Html::_('script', $localesPath, false, true, false, false, true);
WpBookingPro_Html::_('script', $helperPath, false, true, false, false, true);
WpBookingPro_Html::_('script', 'system/fields/calendar.min.js', false, true, false, false, true);
WpBookingPro_Html::_('stylesheet', 'system/fields/calendar' . $cssFileExt, array(), true);
?>
<div class="field-calendar">
	<?php if (!$readonly && !$disabled) : ?>
    <div class="input-append">
		<?php endif; ?>
        <input type="text" id="<?php esc_html_e($id); ?>" name="<?php
		esc_html_e($name); ?>" value="<?php
		echo htmlspecialchars(($value !== '0000-00-00 00:00:00') ? $value : '', ENT_COMPAT,
			'UTF-8'); ?>" <?php esc_html_e($attributes); ?>
			<?php echo !empty($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : ''; ?>
               data-alt-value="<?php
			   echo(htmlspecialchars($value, ENT_COMPAT, 'UTF-8')); ?>" autocomplete="off"/>
        <button type="button" class="<?php echo ($readonly || $disabled) ? 'hidden ' : ''; ?>btn btn-secondary"
                id="<?php esc_html_e($id); ?>_btn"
                data-inputfield="<?php esc_html_e($id); ?>"
                data-dayformat="<?php esc_html_e($format); ?>"
                data-button="<?php esc_html_e($id); ?>_btn"
                data-firstday="<?php esc_html_e(Factory::getLanguage()->getFirstDay()); ?>"
                data-weekend="<?php esc_html_e(Factory::getLanguage()->getWeekEnd()); ?>"
                data-today-btn="<?php esc_html_e($todaybutton); ?>"
                data-week-numbers="<?php esc_html_e($weeknumbers); ?>"
                data-show-time="<?php esc_html_e($showtime); ?>"
                data-show-others="<?php esc_html_e($filltable); ?>"
                data-time-24="<?php esc_html_e($timeformat); ?>"
                data-only-months-nav="<?php esc_html_e($singleheader); ?>"
			<?php echo(isset($minYear) && strlen($minYear) ? 'data-min-year="' . $minYear . '"' : ''); ?>
			<?php echo(isset($maxYear) && strlen($maxYear) ? 'data-max-year="' . $maxYear . '"' : ''); ?>
                title="<?php esc_attr_e('Jlib html behavior open calendar','wpbookingpro'); ?>"
        ><span class="icon-calendar" aria-hidden="true"></span></button>
		<?php if (!$readonly && !$disabled) : ?>
    </div>
<?php endif; ?>
</div>
