<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('script', 'system/html5fallback.js',
	array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
WpBookingPro_Html::_('jquery.select2');
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$list_time = [];
?>
    <div id="<?php esc_html_e($id_by_name) ?>"
         class="<?php esc_html_e($class); ?> field-buffer-time hide-option">
        <select class="time-buffer" name="<?php esc_html_e($name); ?>">
			<?php for ($i = 0; $i <= 23; $i++) { ?>
				<?php if ($i !== 0) { ?>
                    <option <?php esc_html_e($value == $i ? ' selected ' : null) ?>
                            value="<?php esc_html_e($i); ?>"><?php printf("%sh", $i) ?></option>
                    <option <?php esc_html_e($value == ($i + 0.5) ? ' selected ' : null) ?>
                            value="<?php echo($i + 0.5) ?>"><?php printf("%sh 30min", $i) ?></option>
				<?php } else { ?>
                    <option <?php esc_html_e($value == $i ? ' selected ' : null) ?>
                            value="<?php esc_html_e($i); ?>"><?php esc_attr_e('30min','wpbookingpro') ?></option>
				<?php } ?>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/buffertime.less');
$doc->addScriptApplySelector('.field-buffer-time','field_buffertime',array(
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/buffertime.jquery.js');