(function ($) {
    
    $.field_assignedservices = function (element, options) {
        
        var defaults = {
            list_country: [],
            input_name: ""
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element), 
            element = element;    
        plugin.updateData = function () {
            let input_name = plugin.settings.input_name;
            let list_data = [];
            let $list_tr = $element.find('.category-and-service');
            $list_tr.each(function (e) {
                let $tr = $(this);
                let item_data = {
                    service_id: $tr.data('service_id'),
                    enable_customize: $tr.find('.enable-customize').is(':checked'),
                    price: $tr.find('input.price').autoNumeric('get'),
                    minimum_capacity: $tr.find('input.minimum_capacity').val(),
                    maximum_capacity: $tr.find('input.maximum_capacity').val()
                };
                list_data.push(item_data);
            });
            let base64data = $.base64('encode', JSON.stringify(list_data));
            $element.find(`input[name="${input_name}"]`).val(base64data);
        };
        
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find("input.price").each(function () {
                $(this).autoNumeric('init');
            });
            $element.find(".enable-customize").change(function (e) {
                let state = $(this).is(':checked');
                state = !state;
                let $tr = $(this).closest('tr');
                $tr.find('input.price').prop('readonly', state);
                $tr.find('input.minimum_capacity').prop('disabled', state);
                $tr.find('input.maximum_capacity').prop('disabled', state);
                plugin.updateData();
            });
            $element.find("input.price").change(function (e) {
                plugin.updateData();
            });
            $element.find("input.minimum_capacity").change(function (e) {
                plugin.updateData();
            });
            $element.find("input.maximum_capacity").change(function (e) {
                plugin.updateData();
            });
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    
    $.fn.field_assignedservices = function (options) {
        
        return this.each(function () {
            
            if (undefined == $(this).data('field_assignedservices')) {
                var plugin = new $.field_assignedservices(this, options);
                $(this).data('field_assignedservices', plugin);
            }
        });
    }
})(jQuery);