<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_ServiceController")) {
    /**
     * Class WpBookingPro_ServiceController
     */
    class WpBookingPro_ServiceController extends woobooking_controller
    {
        /**
         * @var string
         */
        public $view = "service";

        /**
         * @return mixed
         * @throws Exception
         */
        public function get_service_by_id()
        {
            return self::view("service.form");
        }

        /**
         * @param null $data_post
         * @return array|bool|mixed
         * @throws Exception
         */
        public function ajax_save($data_post = null)
        {
            $input = Factory::getInput();
            $serviceModel = WoobookingModel::getInstance('service');
            if (!$data_post) {
                $data_post = $input->getData()['data'];
            }
            $service = $serviceModel->save($data_post); // TODO: Change the autogenerated stub
            return $service;
        }

        /**
         * @return bool
         * @throws Exception
         */
        public function ajax_delete()
        {
            $serviceModel = WoobookingModel::getInstance('service');
            $input = Factory::getInput();
            $list_delete_service_id = $input->get('list_delete_service_id', array(), 'array');
            foreach ($list_delete_service_id as $service_id) {
                $serviceModel->delete($service_id);
            }
            return true;
        }
    }
}
?>