<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_PaymentController")) {
    /**
     * Class WpBookingPro_PaymentController
     */
    class WpBookingPro_PaymentController extends woobooking_controller
    {
        /**
         * @var string
         */
        public $view = "payment";

        /**
         * @return mixed
         * @throws Exception
         */
        public function get_payment_by_id()
        {
            return self::view("payment.form");
        }

        /**
         * @return mixed
         * @throws Exception
         */
        public function ajax_get_item()
        {
            return self::view("payment.form");
        }

        /**
         * @return mixed
         * @throws Exception
         */
        public function ajax_create_payment_by_payment_name()
        {
            $paymentModel = WoobookingModel::getInstance('payment');
            $input = Factory::getInput();
            $payment_name = $input->getString('payment_name', "");
            $payment = $paymentModel->create_payment_by_payment_name($payment_name);
            return $payment;
        }

        /**
         * @param string $data_post
         * @return array|bool|mixed|stdClass
         */
        public function ajax_save($data_post = "")
        {
            $input = Factory::getInput();
            if (!$data_post) {
                $data_post = $input->getData()['data'];
            }
            $data_post['id'] = 1;
            $data_post = parent::save($data_post); // TODO: Change the autogenerated stub
            $response = new stdClass();
            $response->data = $data_post;
            return $response;
        }

        /**
         * @return bool
         * @throws Exception
         */
        public function ajax_delete()
        {
            $paymentModel = WoobookingModel::getInstance('payment');
            $input = Factory::getInput();
            $list_delete_payment_id = $input->get('list_delete_payment_id', array(), 'array');
            foreach ($list_delete_payment_id as $payment_id) {
                $paymentModel->delete($payment_id);
            }
            return true;
        }
    }
}
?>