"use strict";
(function ($) {
    $.view_list_payment = function (element, options) {
        let defaults = {
            row_payment_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.edit_payment_by_id = function (id) {
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: "payment.ajax_get_item",
                    id: id
                },
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                    loadScripts(response);
                    if (response.result === "success") {
                        $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                        $('body').append(response.data_script);
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "payment.ajax_save");
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('main_table', "main-table");
                        $wooBooking.getDrawer().drawer('toggle');
                        $wooBooking.getDrawer().find('h4.title').html(`Edit payment: ${id}`);
                        $element.find('div.payment-tab').responsiveTabs();
                    }
                }
            });
        };
        plugin.show_list_folder_payment = function () {
            $("#dialog-confirm").dialog("open");
        };
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.btn-close-modal').click(function (e) {
                $("#dialog-confirm").dialog("close");
            })
            $element.find('input[type="radio"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            });
            $element.find('input[type="checkbox"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            });
            $element.find('.btn-add-new').click(function (e) {
                plugin.show_list_folder_payment();
            });
            $element.find('.btn-edit-order').click(function (e) {
                e.prpaymentDefault();
                $wooBooking.getDrawer().drawer('toggle');
            });
            $element.find('.pagination-list-payment').twbsPagination({
                totalPages: 35,
                visiblePages: 7,
                onPageClick: function (payment, page) {
                    $('#page-content').text('Page ' + page);
                }
            });
            $element.find('.btn-edit-payment').live('click', function (e) {
                var id = $(this).data('id');
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: {
                        task: "payment.get_payment_by_id",
                        id: id
                    },
                    beforeSend: function () {
                        $('body').loadingModal();
                    },
                    error: function (xhr) {
                        $.alert({
                            title: 'Error',
                            content: 'there are some error please contact admin !',
                        });
                    },
                    complete: function () {
                        $('body').loadingModal('destroy');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                        if (response.result === "success") {
                            loadScripts(response);
                            $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                            $('body').append(response.data_script);
                            $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "payment.ajax_save");
                            $wooBooking.getDrawer().find('.toolbar-btn-save').data('main_table', "main-table");
                            $wooBooking.getDrawer().drawer('toggle');
                            $wooBooking.getDrawer().find('h4.title').html(`Edit payment: ${id}`);
                            $('.view-payment-form').find('.payment-tab a').on('click', function (e) {
                                e.preventDefault();
                                $(this).tab('show')
                                $('.payment-tab a').removeClass('active');
                                $(this).addClass('active');
                            });
                        } else {
                            $.alert({
                                title: 'Error',
                                content: response.msg
                            });
                        }
                    }
                });
            });
            $element.find('.checked-all').click(function (e) {
                $('table.list-payment').find('.checkbox-item').prop('checked', $(this).is(':checked'));
            });
            $('table.list-payment').find('.checkbox-item').click(function (e) {
                var checkall = true;
                var $all_checkbox = $('table.list-payment').find('.checkbox-item');
                for (let i = 0; i < $all_checkbox.length; i++) {
                    var $checkbox = $($all_checkbox[i]);
                    if (!$checkbox.is(':checked')) {
                        checkall = false;
                    }
                }
                if (checkall) {
                    $element.find('.checked-all').prop('checked', true);
                } else {
                    $element.find('.checked-all').prop('checked', false);
                }
            });
            $element.find('.btn-payment-modal-now').click(function (e) {
                let payment_name = $('#dialog-confirm').find('input[name="payment"]:checked').val();
                if (typeof  payment_name === "undefined") {
                    $.alert({
                        title: 'Error',
                        content: 'Please choose one payment !',
                    });
                    return;
                }
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: {
                        task: "payment.ajax_create_payment_by_payment_name",
                        payment_name: payment_name
                    },
                    beforeSend: function () {
                        $('body').loadingModal();
                    },
                    error: function (xhr) {
                        $.alert({
                            title: 'Error',
                            content: 'there are some error please contact admin !',
                        });
                    },
                    complete: function () {
                        $('body').loadingModal('destroy');
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                        let payment = response.data;
                        plugin.edit_payment_by_id(payment.id);
                        $("#dialog-confirm").dialog("close");
                    }
                });
            });
            $element.find('.btn-delete').click(function (e) {
                let list_delete_payment_id = [];
                $element.find('.delete-payment:checked').each(function (e) {
                    list_delete_payment_id.push($(this).val());
                });
                if (list_delete_payment_id.length === 0) {
                    $.alert({
                        title: 'Error',
                        content: 'Please choose payment before delete!'
                    });
                    return false;
                }
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure delete this payment ?',
                    buttons: {
                        confirm: function () {
                            $.ajax({
                                type: "POST",
                                dataType: "json",
                                url: wpbookingpro_root_url + wpbookingpro_api_task,
                                data: {
                                    task: "payment.ajax_delete",
                                    list_delete_payment_id: list_delete_payment_id
                                },
                                success: function (response) {
                                    location.reload(true);
                                }
                            });
                        },
                        cancel: function () {
                        }
                    }
                });
            });
            let call_back_when_save_success = function (data) {
                var $table_list_payment = $('table.list-payment');
                var $row = $table_list_payment.find(`tr[data-id="${data.id}"]`);
                if ($row.length)
                    $row.find('.name').html(data.name);
                else {
                    $row = $(plugin.settings.row_payment_template);
                    $element.find('.list-payment.main-table').find('tbody').prepend($row);
                }
            };
            $element.find("#dialog-confirm").dialog({
                resizable: false,
                autoOpen: false,
                height: "auto",
                width: 900,
                modal: true,
                open: function (event, ui) {
                },
                close: function (event, ui) {
                }
            }).parent().addClass('custom-payment-dialog');
            $wooBooking.call_back_when_save_success = function (data, is_new) {
                location.reload(true);
            }
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_payment = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_payment')) {
                let plugin = new $.view_list_payment(this, options);
                $(this).data('view_list_payment', plugin);
            }
        });
    }
})(jQuery);
