"use strict";
(function ($) {
    $.view_list_calendar = function (element, options) {
        let defaults = {
            list_event: []
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.up_event = function (event, start, end) {
            let data = {
                id: event.rate_id,
                from: start,
                to: end,
                task: "rate.ajax_save"
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                    if (response.result === "success") {
                        $.alert({
                            title: 'Success',
                            content: 'update day success !',
                        });
                    } else {
                        $.alert({
                            title: 'Error',
                            content: response.msg
                        });
                    }
                }
            });
        };
        plugin.get_full_time = function (date) {
            let current_datetime = new Date(date);
            let formatted_date = current_datetime.getFullYear() + "-" + (current_datetime.getMonth() + 1) + "-" + current_datetime.getDate() + " " + current_datetime.getHours() + ":" + current_datetime.getMinutes() + ":" + current_datetime.getSeconds();
            return formatted_date;
        };
        plugin.create_Appointment = function (info) {
            let start = plugin.get_full_time(info.startStr);
            let end = plugin.get_full_time(info.endStr);
            let data = {
                from: start,
                to: end,
                task: "appointment.ajax_get_item"
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                    if (response.result === "success") {
                        $wooBooking.loadScripts(response);
                        $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "service.ajax_save");
                        $wooBooking.getDrawer().find('.toolbar-btn-duplicate').data('task', "service.ajax_duplicate");
                        $wooBooking.getDrawer().find('.toolbar-btn-duplicate').data('id', id);
                        $wooBooking.getDrawer().find('.toolbar-btn-delete').data('id', id);
                        $wooBooking.getDrawer().find('.toolbar-btn-delete').data('task', "service.ajax_delete");
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('main_table', "main-table");
                        $wooBooking.getDrawer().find('.toolbar-btn-duplicate').prop('disabled', false);
                        $wooBooking.getDrawer().find('.toolbar-btn-published').prop('disabled', false);
                        $wooBooking.getDrawer().find('.toolbar-btn-delete').prop('disabled', false);
                        $wooBooking.getDrawer().drawer('toggle');
                    } else {
                        $.alert({
                            title: 'Error',
                            content: response.msg
                        });
                    }
                }
            });
        };
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            var calendarEl = document.getElementById('calendar');
            let list_event = plugin.settings.list_event;
            var calendar = new FullCalendar.Calendar(calendarEl, {
                plugins: ['interaction', 'dayGrid', 'timeGrid', 'bootstrapPlugin', 'interactionPlugin', 'momentPlugin'],
                selectable: true,
                header: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay'
                },
                select: function (info) {
                    plugin.create_Appointment(info);
                },
                droppable: true,
                themeSystem: 'bootstrap',
                events: list_event,
                color: 'yellow',
                textColor: 'black',
                editable: true,
                eventDrop: function (info, delta, revertFunc) {
                    let event = info.event.extendedProps;
                    let start = plugin.get_full_time(info.event.start);
                    let end = plugin.get_full_time(info.event.end);
                    plugin.up_event(event, start, end);
                },
                eventResize: function (info) {
                    let event = info.event.extendedProps;
                    let start = plugin.get_full_time(info.event.start);
                    let end = plugin.get_full_time(info.event.end);
                    plugin.up_event(event, start, end);
                },
                eventClick: function (event, element) {
                },
                eventRender: function (info) {
                    $(info.el).tooltip();
                    $(info.el).popover({
                        html: true,
                        content: function () {
                            return info.event.extendedProps.description;
                        },
                        title: function () {
                            return info.event.extendedProps.title;
                        },
                        delay: {"show": 500, "hide": 100},
                        placement: "top",
                        trigger: 'hover'
                    }).on('mouseenter', function () {
                        var _this = this;
                        $(this).popover('show');
                        $('.popover').on('mouseleave', function () {
                            $(_this).popover('hide');
                        });
                    }).on('mouseleave', function () {
                        var _this = this;
                        setTimeout(function () {
                            if (!$('.popover:hover').length) {
                                $(_this).popover('hide');
                            }
                        }, 300);
                    });
                },
            });
            calendar.render();
        };
        plugin.init();
    };
    $.fn.view_list_calendar = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('view_list_calendar')) {
                let plugin = new $.view_list_calendar(this, options);
                $(this).data('view_list_calendar', plugin);
            }
        });
    }
})(jQuery);