"use strict";
(function ($) {
    $.view_create_template = function (element, options) {
        let defaults = {
            tool_check: [],
            step: 1
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.tree-node input.node').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            });
            $element.find('input[name="view_name"]').keyup(function (e) {
                let view_name = $(this).val();
                if (view_name.trim() === "") {
                    $element.find('span.node').each(function (e) {
                        let $self = $(this);
                        let node_name = $self.data('node_name');
                        $self.html(node_name);
                    });
                } else {
                    $element.find('span.node').each(function (e) {
                        let $self = $(this);
                        let node_name = $self.data('node_name');
                        node_name = node_name.replace("template", view_name);
                        node_name = node_name.replace("Template", plugin.capitalizeFirstLetter(view_name));
                        $self.html(node_name);
                    });
                }
            });
            $element.find('.tree-node .view').click(function (e) {
                let $li = $(this).closest('li');
                let file_path = $li.find('input.node').val();
                $element.find('.tree-node .view').removeClass('edit');
                $element.find('.tree-node li').removeClass('show-edit');
                $li.find('.view').addClass('edit');
                $li.addClass('show-edit')
            });
        };
        plugin.capitalizeFirstLetter = function (string) {
            return string.charAt(0).toUpperCase() + string.slice(1);
        };
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_create_template = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_create_template')) {
                let plugin = new $.view_create_template(this, options);
                $(this).data('view_create_template', plugin);
            }
        });
    }
})(jQuery);
