"use strict";
(function ($) {
    $.list_view_order_package = function (element, options) {
        let defaults = {
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.edit_order_package = function ($row_item) {
            let id = $row_item.data('id');
        };
        plugin.edit_order_detail = function ($row_item) {
            let id = $row_item.data('id');
            let data = {
                id: id,
                task: "order_package.ajax_edit_order_detail"
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                },
                success: function (response) {
                    response = JSON.parse(response);
                    if (response.result === "success") {
                        loadScripts(response);
                        $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                        $('body').append(response.data_script);
                        $wooBooking.getDrawer().drawer('toggle');
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "order_package.ajax_save_order_detail");
                    } else {
                        $.alert({
                            title: 'Error',
                            content: response.msg
                        });
                    }
                }
            });
        };
        plugin.change_status_order = function (order_id, order_status_id) {
            let data = {
                order_id: order_id,
                order_status_id: order_status_id,
                task: "order_package.ajax_change_order_status"
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                }
            });
        };
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('input[type="checkbox"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            });
            $element.find('.order-status').select2(
                {containerCssClass: "order-status"}
            );
            $element.find('.list-rate-info').slideUp();
            $element.find('.show-rate-detail').click(function (e) {
                let $tr = $(this).closest('tr');
                let order_id = $tr.data('order_id');
                $tr.nextAll(`.list-rate-info-${order_id}`).slideToggle(500);
            });
            $element.find('.btn-delete').click(function (e) {
                let list_delete_order_id = [];
                $element.find('.checkbox-item:checked').each(function (e) {
                    list_delete_order_id.push($(this).val());
                });
                if (list_delete_order_id.length === 0) {
                    $.alert({
                        title: 'Error',
                        content: 'Please select the event to delete!'
                    });
                    return false;
                }
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure delete this order ?',
                    buttons: {
                        confirm: function () {
                            $.ajax({
                                type: "POST",
                                dataType: "json",
                                url: wpbookingpro_root_url + wpbookingpro_api_task,
                                data: {
                                    task: "appointment.ajax_delete",
                                    list_delete_order_id: list_delete_order_id
                                },
                                success: function (response) {
                                    location.reload(true);
                                }
                            });
                        },
                        cancel: function () {
                        }
                    }
                });
            });
            $element.find('.order-status').change(function (e) {
                let $tr = $(this).closest('.row-item-order');
                let order_id = $tr.data('order_id');
                let order_status_id = $(this).val();
                plugin.change_status_order(order_id, order_status_id);
            });
        };
        plugin.example_function = function () {
        };
        plugin.init();
    };
    $.fn.list_view_order_package = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('list_view_order_package')) {
                let plugin = new $.list_view_order_package(this, options);
                $(this).data('list_view_order_package', plugin);
            }
        });
    }
})(jQuery);
