<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Filesystem\File;

require_once WPBOOKINGPRO_PATH_ROOT . "/admin/nb_apps/nb_woobooking/html/WooBookingHtml.php";
require_once WPBOOKINGPRO_PATH_ROOT . "/admin/nb_apps/nb_woobooking/helpers/RateHelper.php";
if(!class_exists("WpBookingPro_Helper")) {
    /**
     * Class WpBookingPro_Helper
     */
    class WpBookingPro_Helper
    {
        /**
         * @param int $cost
         * @param string $currency
         * @return string
         */
        public static function format_currency($cost = 0, $currency = "$")
        {
            return "$currency $cost";
        }

        /**
         * @param int $cost
         * @param string $hour
         * @return string
         */
        public static function format_hour($cost = 0, $hour = "h")
        {
            return " $cost$hour";
        }


        /**
         * @return array
         */
        public static function function_get_view()
        {
            $file_xml_path_app = WPBOOKINGPRO_PATH_ADMIN_COMPONENT . "/views.xml";
            $xml = simplexml_load_file($file_xml_path_app);
            $list_menu_by_xml = [];
            $index = 21;
            foreach ($xml->view as $view) {
                $list_menu_by_xml[] = (object)[
                    'id' => (string)$view->attributes()['id'],
                    'menu_slug' => (string)$view->attributes()['menu_slug'],
                    'label' => (string)$view->attributes()['label'],
                    'page_title' => (string)$view->attributes()['page_title'],
                    'capability' => (string)$view->attributes()['capability'],
                    'icon' => (string)$view->attributes()['icon'],
                    'is_system' => (boolean)$view->attributes()['is_system'],
                ];
                $index++;
            }
            return $list_menu_by_xml;
        }

        /**
         * @return mixed
         */
        public static function get_limit_per_page()
        {
            $appConfig = Factory::getAppConfig();
            return $appConfig->get('limit_per_page', 20);
        }

        /**
         * @param $dir
         * @param array $results
         * @param array $exclude
         * @param array $filter
         * @return array
         */
        public static function getDirContents($dir, &$results = array(), $exclude = array(), $filter = array())
        {
            $files = scandir($dir);
            $filter = array_map('strtolower', $filter);
            foreach ($files as $key => $value) {
                if (in_array($value, $exclude)) {
                    continue;
                }
                $path = realpath($dir . DIRECTORY_SEPARATOR . $value);
                $extension = strtolower(File::getExt($path));
                if (!is_dir($path)) {
                    if (empty($filter)) {
                        $results[] = $path;
                    } elseif (in_array($extension, $filter)) {
                        $results[] = $path;
                    }
                } else {
                    if ($value != "." && $value != "..") {
                        self::getDirContents($path, $results, $exclude, $filter);
                        $results[] = $path;
                    }
                }
            }
            return $results;
        }
    }
}