<?php
    $testimonial_id     = uniqid('testimonial_id_');
    $style              = $settings['style'];
    $testimonial_list   = $settings['testimonial_list'];
    $show_pagination    = $settings['show_pagination'];
    $show_navigation    = $settings['show_navigation'];
?>
<div class="nb-testimonials-container" id="<?php echo esc_attr($testimonial_id);?>" data-style="<?php echo esc_attr($style);?>">

    <div class="swiper-container nb-testimonials-wrapper <?php echo esc_attr($style);?>">
        <div class="swiper-wrapper">
            <?php foreach($testimonial_list as $testimonial):?>
                <?php if($style == "multiple_column"):?>
                    <div class="swiper-slide testimonial-item">

                        <p class="testimonial-content"><?php echo $testimonial['content'];?></p>
                        <h5 class="testimonial-name"><?php echo $testimonial['name'];?></h5>
                        <span class="testimonial-position"><?php echo $testimonial['position'];?></span>
                        <div class="testimonial-avatar">
                            <img src="<?php echo esc_url($testimonial['avatar']['url']);?>" alt="<?php echo esc_attr($testimonial['name']);?>"/>
                        </div>

                    </div>
                <?php elseif($style == "one_column"):?>
                    <div class="swiper-slide testimonial-item">
                        <div class="item-container">
                            <div class="item-wrapper">
                                <div class="testimonial-avatar">
                                    <img src="<?php echo esc_url($testimonial['avatar']['url']);?>" alt="<?php echo esc_attr($testimonial['name']);?>"/>
                                </div>
                                <div class="testimonial-data">
                                    <p class="testimonial-content"><?php echo $testimonial['content'];?></p>
                                    <h5 class="testimonial-name"><?php echo $testimonial['name'];?></h5>
                                    <span class="testimonial-position"><?php echo $testimonial['position'];?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif;?>
            <?php endforeach;?>
        </div>

        <?php if ($show_pagination): ?>
            <div class="swiper-pagination"></div>
        <?php endif; ?>

        <?php if ($show_navigation): ?>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        <?php endif; ?>

    </div>
</div>