<?php 

$query_args = array(
    'post_type' => 'post',
    'post_status' => 'publish',
    'posts_per_page' => $settings['posts_per_page']
);

$nb_posts = new WP_Query($query_args);
?>

<div class="nb-post-wrapper">
    <?php while ($nb_posts->have_posts()) : $nb_posts->the_post();?>
        <div class="nb-post-item">
            <?php
                $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'medium');
            ?>
            <div class="nb-post-thumbnail">
                <a href="<?php the_permalink(); ?>" style="background-image:url(<?php echo $featured_img_url; ?>);"></a>
                <div class="nb-post-date">
                    <span class="nb-post-day"><?php echo date_i18n('j', strtotime(get_the_date(''))); ?></span> 
                    <span class="nb-post-month"><?php echo date_i18n('M', strtotime(get_the_date(''))); ?></span>
                </div>
            </div>

            <div class="nb-post-data">

                <div class="nb-post-author">
                    <p><?php esc_html_e('By', 'spaclub-elements');?> <?php the_author(); ?></p>
                </div>

                <?php the_title( '<h5 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h5>' );?>

                <div class="read-more-link">
                    <a class="nb-primary-button" href="<?php echo get_permalink(); ?>"><?php echo esc_html__('Read More', 'wp-booking'); ?></a>
                </div>
                
            </div>
        </div>
    <?php endwhile;?>
    <?php wp_reset_postdata();?>
</div>