<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_ServiceView")) {
    /**
     * Class WpBookingPro_ServiceView
     */
    class WpBookingPro_ServiceView extends WooBookingView
    {
        /**
         * @var
         */
        public $list;
        /**
         * @var
         */
        public $filterForm;
        /**
         * @var
         */
        public $from;

        /**
         * @param null $tpl
         * @return false|string
         * @throws Exception
         */
        public function display($tpl = null)
        {
            $input = Factory::getInput();
            switch ($tpl) {
                case "config_list":
                    $modelBlock = WoobookingModel::getInstance('block');
                    $id = $input->getInt('id', 0);
                    $this->item = $modelBlock->getItem($id);
                    $this->form = $modelBlock->getFormConfigBlock('service', $tpl);
                    break;
                case "form":
                    $id = $input->getInt('id', 0);
                    $this->item = $modelEvent->getItem($id);
                    $this->form = $modelEvent->getForm();
                    break;
                case "detail":
                    $input = Factory::getInput();
                    $service_id = $input->getInt('service_id', 0);
                    $serviceModel = WoobookingModel::getInstance('service');
                    $this->item = $serviceModel->getItem($service_id);
                    $this->form = $serviceModel->getForm();
                    break;
                case "detail_new":
                    $service_id = $input->getInt('service_id', 0);
                    $serviceModel = WoobookingModel::getInstance('service');
                    $this->item = $serviceModel->getItem($service_id);
                    $this->form = $serviceModel->getForm();
                    $this->list_event=$serviceModel->getEventByServiceId($service_id);
                    $reviewsModel = WoobookingModel::getInstance('service');
                    $this->list_reviews=$reviewsModel->getReviewByServiceId($service_id);
                    break;
                case "list":
                    $input = Factory::getInput();
                    $category_id = $input->getInt('category_id', 0);
                    $modeServices = WoobookingModel::getInstance('services');
                    $this->list = $modeServices->getListServiceByCategoryId($category_id);
                    break;
                case "list_service_layout":
                default:
                    $modeServices = WoobookingModel::getInstance('services');
                    $this->list=$modeServices->getList();
                    $categoriesModel = WoobookingModel::getInstance('categories');
                    $this->form = new stdClass();
                    $this->form->list_category = $categoriesModel->getList();
                    $locationsModel = WoobookingModel::getInstance('locations');
                    $this->form->list_location = $locationsModel->getList();
                    $employeesModel = WoobookingModel::getInstance('employees');
                    $this->form->list_employee = $employeesModel->getList();
                    $modeEvents = WoobookingModel::getInstance('events');
                    $this->form_booking = $modeEvents->getFormBooking();
                    $this->totalRecord=$modeServices->getTotalRecord();

                    break;
            }
            return parent::display($tpl);
        }
    }
}